/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.classloader;

import io.prestosql.plugin.base.classloader.ClassLoaderSafeRecordSet;
import io.prestosql.plugin.base.classloader.ForClassLoaderSafe;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConnectorRecordSetProvider delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorRecordSetProvider(@ForClassLoaderSafe ConnectorRecordSetProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(transaction, session, split, table, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(transactionHandle, session, split, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }
}

