/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.base.security.CatalogAccessControlRule;
import io.prestosql.plugin.base.security.ImpersonationRule;
import io.prestosql.plugin.base.security.PrincipalUserMatchRule;
import io.prestosql.plugin.base.security.QueryAccessRule;
import io.prestosql.plugin.base.security.SchemaAccessControlRule;
import io.prestosql.plugin.base.security.SystemInformationRule;
import io.prestosql.plugin.base.security.TableAccessControlRule;
import java.util.List;
import java.util.Optional;

public class FileBasedSystemAccessControlRules {
    private final List<CatalogAccessControlRule> catalogRules;
    private final Optional<List<QueryAccessRule>> queryAccessRules;
    private final Optional<List<ImpersonationRule>> impersonationRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;
    private final Optional<List<SystemInformationRule>> systemInformationRules;
    private final Optional<List<SchemaAccessControlRule>> schemaRules;
    private final Optional<List<TableAccessControlRule>> tableRules;

    @JsonCreator
    public FileBasedSystemAccessControlRules(@JsonProperty(value="catalogs") Optional<List<CatalogAccessControlRule>> catalogRules, @JsonProperty(value="queries") Optional<List<QueryAccessRule>> queryAccessRules, @JsonProperty(value="impersonation") Optional<List<ImpersonationRule>> impersonationRules, @JsonProperty(value="principals") Optional<List<PrincipalUserMatchRule>> principalUserMatchRules, @JsonProperty(value="system_information") Optional<List<SystemInformationRule>> systemInformationRules, @JsonProperty(value="schemas") Optional<List<SchemaAccessControlRule>> schemaAccessControlRules, @JsonProperty(value="tables") Optional<List<TableAccessControlRule>> tableAccessControlRules) {
        this.catalogRules = (List)catalogRules.map(ImmutableList::copyOf).orElse(ImmutableList.of());
        this.queryAccessRules = queryAccessRules.map(ImmutableList::copyOf);
        this.principalUserMatchRules = principalUserMatchRules.map(ImmutableList::copyOf);
        this.impersonationRules = impersonationRules.map(ImmutableList::copyOf);
        this.systemInformationRules = systemInformationRules.map(ImmutableList::copyOf);
        this.schemaRules = schemaAccessControlRules.map(ImmutableList::copyOf);
        this.tableRules = tableAccessControlRules.map(ImmutableList::copyOf);
    }

    public List<CatalogAccessControlRule> getCatalogRules() {
        return this.catalogRules;
    }

    public Optional<List<QueryAccessRule>> getQueryAccessRules() {
        return this.queryAccessRules;
    }

    public Optional<List<ImpersonationRule>> getImpersonationRules() {
        return this.impersonationRules;
    }

    public Optional<List<PrincipalUserMatchRule>> getPrincipalUserMatchRules() {
        return this.principalUserMatchRules;
    }

    public Optional<List<SystemInformationRule>> getSystemInformationRules() {
        return this.systemInformationRules;
    }

    public Optional<List<SchemaAccessControlRule>> getSchemaRules() {
        return this.schemaRules;
    }

    public Optional<List<TableAccessControlRule>> getTableRules() {
        return this.tableRules;
    }
}

