/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.classloader;

import io.prestosql.plugin.base.classloader.ForClassLoaderSafe;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.connector.ConnectorBucketNodeMap;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public final class ClassLoaderSafeNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final ConnectorNodePartitioningProvider delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeNodePartitioningProvider(@ForClassLoaderSafe ConnectorNodePartitioningProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            BucketFunction bucketFunction = this.delegate.getBucketFunction(transactionHandle, session, partitioningHandle, partitionChannelTypes, bucketCount);
            return bucketFunction;
        }
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List list = this.delegate.listPartitionHandles(transactionHandle, session, partitioningHandle);
            return list;
        }
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorBucketNodeMap connectorBucketNodeMap = this.delegate.getBucketNodeMap(transactionHandle, session, partitioningHandle);
            return connectorBucketNodeMap;
        }
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ToIntFunction toIntFunction = this.delegate.getSplitBucketFunction(transactionHandle, session, partitioningHandle);
            return toIntFunction;
        }
    }
}

