/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.base.security.SchemaAccessControlRule;
import io.prestosql.plugin.base.security.SessionPropertyAccessControlRule;
import io.prestosql.plugin.base.security.TableAccessControlRule;
import java.util.List;
import java.util.Optional;

public class AccessControlRules {
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;

    @JsonCreator
    public AccessControlRules(@JsonProperty(value="schemas") Optional<List<SchemaAccessControlRule>> schemaRules, @JsonProperty(value="tables") Optional<List<TableAccessControlRule>> tableRules, @JsonProperty(value="session_properties") @JsonAlias(value={"sessionProperties"}) Optional<List<SessionPropertyAccessControlRule>> sessionPropertyRules) {
        this.schemaRules = schemaRules.orElse((List<SchemaAccessControlRule>)ImmutableList.of((Object)SchemaAccessControlRule.ALLOW_ALL));
        this.tableRules = tableRules.orElse((List<TableAccessControlRule>)ImmutableList.of((Object)TableAccessControlRule.ALLOW_ALL));
        this.sessionPropertyRules = sessionPropertyRules.orElse((List<SessionPropertyAccessControlRule>)ImmutableList.of((Object)SessionPropertyAccessControlRule.ALLOW_ALL));
    }

    public List<SchemaAccessControlRule> getSchemaRules() {
        return this.schemaRules;
    }

    public List<TableAccessControlRule> getTableRules() {
        return this.tableRules;
    }

    public List<SessionPropertyAccessControlRule> getSessionPropertyRules() {
        return this.sessionPropertyRules;
    }
}

