/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.type;

import io.prestosql.plugin.base.type.AbstractPrestoTimestampEncoder;
import io.prestosql.plugin.base.type.DecodedTimestamp;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Timestamps;
import org.joda.time.DateTimeZone;

class ShortTimestampEncoder
extends AbstractPrestoTimestampEncoder<Long> {
    ShortTimestampEncoder(TimestampType type, DateTimeZone timeZone) {
        super(type, timeZone);
    }

    @Override
    public void write(DecodedTimestamp decodedTimestamp, BlockBuilder blockBuilder) {
        Long micros = this.getTimestamp(decodedTimestamp);
        this.type.writeLong(blockBuilder, micros.longValue());
    }

    @Override
    public Long getTimestamp(DecodedTimestamp decodedTimestamp) {
        long micros = this.timeZone != DateTimeZone.UTC ? this.timeZone.convertUTCToLocal(decodedTimestamp.getEpochSeconds() * 1000L) * 1000L : decodedTimestamp.getEpochSeconds() * 1000000L;
        int nanosOfSecond = (int)Timestamps.round((long)decodedTimestamp.getNanosOfSecond(), (int)(9 - this.type.getPrecision()));
        return micros + (long)(nanosOfSecond / 1000);
    }
}

