/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class CreateTableTests
extends ProductTest {
    @Test(groups={"create_table"})
    public void shouldCreateTableAsSelect() {
        String tableName = "create_table_as_select";
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s(nationkey, name) AS SELECT n_nationkey, n_name FROM nation", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
    }

    @Test(groups={"create_table"})
    public void shouldCreateTableAsEmptySelect() {
        String tableName = "create_table_as_empty_select";
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s(nationkey, name) AS SELECT n_nationkey, n_name FROM nation WHERE 0 is NULL", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT nationkey, name FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(0);
    }
}

