/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ImpersonationTests
extends ProductTest {
    private QueryExecutor aliceExecutor;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.alice@presto.jdbc_user")
    private String aliceJdbcUser;
    @Inject
    @Named(value="databases.presto.configured_hdfs_user")
    private String configuredHdfsUser;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectoryPath;

    @BeforeTestWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToPresto("alice@presto");
    }

    @Test(groups={"hdfs_no_impersonation", "profile_specific_tests"})
    public void testHdfsImpersonationDisabled() {
        String tableName = "check_hdfs_impersonation_disabled";
        this.checkTableOwner(tableName, this.configuredHdfsUser, this.aliceExecutor);
    }

    @Test(groups={"hdfs_impersonation", "profile_specific_tests"})
    public void testHdfsImpersonationEnabled() {
        String tableName = "check_hdfs_impersonation_enabled";
        this.checkTableOwner(tableName, this.aliceJdbcUser, this.aliceExecutor);
    }

    private String getTableLocation(String tableName) {
        return this.warehouseDirectoryPath + '/' + tableName;
    }

    private void checkTableOwner(String tableName, String expectedOwner, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = this.getTableLocation(tableName);
        String owner = this.hdfsClient.getOwner(tableLocation);
        Assert.assertEquals((String)owner, (String)expectedOwner);
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }
}

