/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.JdbcDriverUtils;
import java.sql.JDBCType;
import org.testng.annotations.Test;

public class SystemConnectorTests
extends ProductTest {
    @Test(groups={"system", "jdbc"})
    public void selectRuntimeNodes() {
        String sql = "SELECT node_id, http_uri, node_version, state FROM system.runtime.nodes";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)sql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void selectRuntimeQueries() {
        String sql = "SELECT  query_id,  state,  user,  query,  resource_group_id,  queued_time_ms,  analysis_time_ms,  distributed_planning_time_ms,  created,  started,  last_heartbeat,  'end' FROM system.runtime.queries";
        JDBCType arrayType = JdbcDriverUtils.usingTeradataJdbcDriver(QueryExecutor.defaultQueryExecutor().getConnection()) ? JDBCType.VARCHAR : JDBCType.ARRAY;
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)sql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, arrayType, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.VARCHAR}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void selectRuntimeTasks() {
        String sql = "SELECT  node_id,  task_id,  stage_id,  query_id,  state,  splits,  queued_splits,  running_splits,  completed_splits,  split_scheduled_time_ms,  split_cpu_time_ms,  split_blocked_time_ms,  raw_input_bytes,  raw_input_rows,  processed_input_bytes,  processed_input_rows,  output_bytes,  output_rows,  physical_written_bytes,  created,  start,  last_heartbeat,  'end' FROM SYSTEM.runtime.tasks";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)sql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.VARCHAR}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void selectMetadataCatalogs() {
        String sql = "select catalog_name, connector_id from system.metadata.catalogs";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)sql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR}).hasAnyRows();
    }
}

