/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.cassandra;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.cassandra.MultiColumnKeyTableDefinition;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestSelectMultiColumnKey
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY);
    }

    @Test(groups={"cassandra"})
    public void testSelectWithEqualityFilterOnClusteringKey() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE key = 'a1'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 1"})});
    }

    @Test(groups={"cassandra"})
    public void testSelectWithEqualityFilterOnPrimaryAndClusteringKeys() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Alice' and key = 'a1' and updated_at = TIMESTAMP '2015-01-01 01:01:01'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 1"})});
    }

    @Test(groups={"cassandra"})
    public void testSelectWithMixedFilterOnPrimaryAndClusteringKeys() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Alice' and key < 'b' and updated_at >= TIMESTAMP '2015-01-01 01:01:01'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 1"})});
    }

    @Test(groups={"cassandra"})
    public void testSelectWithFilterOnPrimaryKeyNoMatch() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'George'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasNoRows();
    }

    @Test(groups={"cassandra"})
    public void testSelectWithFilterOnPrefixOfClusteringKey() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Bob' and key = 'b1'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 2"})});
    }

    @Test(groups={"cassandra"})
    public void testSelectWithFilterOnSecondClusteringKey() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Bob' and updated_at = TIMESTAMP '2014-02-02 03:04:05'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 2"})});
    }
}

