/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutionException;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestAvroSchemaUrl
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;

    @BeforeTestWithContext
    public void setup() throws Exception {
        this.hdfsClient.createDirectory("/user/hive/warehouse/TestAvroSchemaUrl/schemas");
        this.saveResourceOnHdfs("avro/original_schema.avsc", "/user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc");
        this.saveResourceOnHdfs("avro/column_with_long_type_definition_schema.avsc", "/user/hive/warehouse/TestAvroSchemaUrl/schemas/column_with_long_type_definition_schema.avsc");
        this.hdfsClient.createDirectory("/user/hive/warehouse/TestAvroSchemaUrl/data");
        this.saveResourceOnHdfs("avro/column_with_long_type_definition_data.avro", "/user/hive/warehouse/TestAvroSchemaUrl/data/column_with_long_type_definition_data.avro");
    }

    @AfterTestWithContext
    public void cleanup() {
        this.hdfsClient.delete("/user/hive/warehouse/TestAvroSchemaUrl");
    }

    private void saveResourceOnHdfs(String resource, String location) throws IOException {
        this.hdfsClient.delete(location);
        try (InputStream inputStream = Resources.asByteSource((URL)Resources.getResource((String)resource)).openStream();){
            this.hdfsClient.saveFile(location, inputStream);
        }
    }

    @DataProvider
    public Object[][] avroSchemaLocations() {
        return new Object[][]{{"file:///docker/volumes/presto-product-tests/avro/original_schema.avsc"}, {"hdfs://hadoop-master:9000/user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc"}, {"hdfs:///user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc"}, {"/user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc"}};
    }

    @Test(dataProvider="avroSchemaLocations", groups={"avro", "storage_formats"})
    public void testHiveCreatedTable(String schemaLocation) {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE test_avro_schema_url_hive ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat' TBLPROPERTIES ('avro.schema.url'='%s')", schemaLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO test_avro_schema_url_hive VALUES ('some text', 123042)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_avro_schema_url_hive", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_avro_schema_url_hive", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_avro_schema_url_hive", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"avro"})
    public void testAvroSchemaUrlInSerdeProperties() throws IOException {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_in_serde_properties", new QueryExecutor.QueryParam[0]);
        String schemaLocationOnHdfs = "/user/hive/warehouse/TestAvroSchemaUrl/schemas/test_avro_schema_url_in_serde_properties.avsc";
        this.saveResourceOnHdfs("avro/original_schema.avsc", schemaLocationOnHdfs);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE test_avro_schema_url_in_serde_properties ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' WITH SERDEPROPERTIES ('avro.schema.url'='%s')STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat' ", schemaLocationOnHdfs), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM test_avro_schema_url_in_serde_properties", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})});
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("ALTER TABLE test_avro_schema_url_in_serde_properties ADD COLUMN new_dummy_col varchar", new QueryExecutor.QueryParam[0])).failsWithMessage("ALTER TABLE not supported when Avro schema url is set");
        QueryExecutors.onHive().executeQuery("INSERT INTO test_avro_schema_url_in_serde_properties VALUES ('some text', 2147483635)", new QueryExecutor.QueryParam[0]);
        this.saveResourceOnHdfs("avro/change_column_type_schema.avsc", schemaLocationOnHdfs);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM test_avro_schema_url_in_serde_properties", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "bigint", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_avro_schema_url_in_serde_properties", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 0x7FFFFFF3L})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_avro_schema_url_in_serde_properties", new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="avroSchemaLocations", groups={"avro", "storage_formats"})
    public void testPrestoCreatedTable(String schemaLocation) {
        QueryExecutors.onPresto().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_presto", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE test_avro_schema_url_presto (dummy_col VARCHAR) WITH (format='AVRO', avro_schema_url='%s')", schemaLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("INSERT INTO test_avro_schema_url_presto VALUES ('some text', 123042)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_avro_schema_url_presto", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_avro_schema_url_presto", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_avro_schema_url_presto", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"avro", "storage_formats"})
    public void testTableWithLongColumnType() {
        QueryExecutors.onPresto().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_long_column", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_avro_schema_url_long_column (dummy_col VARCHAR) WITH (format='AVRO', avro_schema_url='/user/hive/warehouse/TestAvroSchemaUrl/schemas/column_with_long_type_definition_schema.avsc')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("LOAD DATA INPATH '/user/hive/warehouse/TestAvroSchemaUrl/data/column_with_long_type_definition_data.avro' INTO TABLE test_avro_schema_url_long_column", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name = 'test_avro_schema_url_long_column'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col"}), QueryAssert.Row.row((Object[])new Object[]{"long_record"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT   string_col,   long_record.record_field,   long_record.record_field422,   regexp_replace(json_format(CAST(long_record AS json)), '(?s)^.*(.{20})$', '... $1') FROM test_avro_schema_url_long_column", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col val", "val", "val422", "... \",\"val498\",\"val499\"]"})});
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_avro_schema_url_long_column", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"avro", "storage_formats"})
    public void testPartitionedTableWithLongColumnType() {
        if (this.isOnHdp()) {
            throw new SkipException("Skipping on HDP");
        }
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_partitioned_long_column", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_avro_schema_url_partitioned_long_column PARTITIONED BY (pkey STRING) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat' TBLPROPERTIES ('avro.schema.url'='/user/hive/warehouse/TestAvroSchemaUrl/schemas/column_with_long_type_definition_schema.avsc')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("LOAD DATA INPATH '/user/hive/warehouse/TestAvroSchemaUrl/data/column_with_long_type_definition_data.avro' INTO TABLE test_avro_schema_url_partitioned_long_column PARTITION(pkey='partition key value')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name = 'test_avro_schema_url_partitioned_long_column'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"pkey"}), QueryAssert.Row.row((Object[])new Object[]{"string_col"}), QueryAssert.Row.row((Object[])new Object[]{"long_record"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT   pkey,   string_col,   long_record.record_field,   long_record.record_field422,   regexp_replace(json_format(CAST(long_record AS json)), '(?s)^.*(.{20})$', '... $1') FROM test_avro_schema_url_partitioned_long_column", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"partition key value", "string_col val", "val", "val422", "... \",\"val498\",\"val499\"]"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_partitioned_long_column", new QueryExecutor.QueryParam[0]);
    }

    private boolean isOnHdp() {
        try {
            QueryResult queryResult = QueryExecutors.onHive().executeQuery("SET system:hdp.version", new QueryExecutor.QueryParam[0]);
            String hdpVersion = (String)queryResult.row(0).get(0);
            return !Strings.isNullOrEmpty((String)hdpVersion);
        }
        catch (QueryExecutionException e) {
            return false;
        }
    }
}

