/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.airlift.log.Logger;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestComments
extends ProductTest {
    private static final String COMMENT_TABLE_NAME = "comment_test";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTable() {
        try {
            QueryExecutor.query((String)"DROP TABLE IF EXISTS comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            Logger.get(((Object)((Object)this)).getClass()).warn((Throwable)e, "failed to drop table");
        }
    }

    @Test(groups={"comment"})
    public void testCommentTable() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'old comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)createTableSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryResult actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)createTableSql);
        String commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'new comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON TABLE %s IS 'new comment'", COMMENT_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
        commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT ''\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON TABLE %s IS ''", COMMENT_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
        commentedCreateTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutor.query((String)String.format("COMMENT ON TABLE %s IS NULL", COMMENT_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutor.query((String)"SHOW CREATE TABLE comment_test", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(actualResult.row(0).get(0), (Object)commentedCreateTableSql);
    }
}

