/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.util.List;
import org.testng.annotations.Test;

public class TestCsv
extends ProductTest {
    private static final String TPCH_SCHEMA = "tiny";

    @Test(groups={"storage_formats"})
    public void testInsertIntoCsvTable() {
        this.testInsertIntoCsvTable("storage_formats_test_insert_into_csv", "");
    }

    @Test(groups={"storage_formats"})
    public void testInsertIntoCsvTableWithCustomProperties() {
        this.testInsertIntoCsvTable("storage_formats_test_insert_into_csv_with_custom_properties", ", csv_escape = 'e', csv_separator='s', csv_quote='q'");
    }

    private void testInsertIntoCsvTable(String tableName, String additionalTableProperties) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s(   linestatus    varchar,   shipinstruct  varchar,   shipmode      varchar,   comment       varchar,   returnflag    varchar) WITH (format='CSV' %s)", tableName, additionalTableProperties), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("select max(linestatus), max(shipinstruct), max(shipmode) from %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testCreateCsvTableAs() {
        this.testCreateCsvTableAs("");
    }

    @Test(groups={"storage_formats"})
    public void testCreateCsvTableAsWithCustomProperties() {
        this.testCreateCsvTableAs(", csv_escape = 'e', csv_separator = 's', csv_quote = 'q'");
    }

    private void testCreateCsvTableAs(String additionalParameters) {
        String tableName = "test_csv_table";
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s WITH (format='CSV' %s) AS SELECT cast(linestatus AS varchar) AS linestatus, cast(shipmode AS varchar) AS shipmode, cast(returnflag AS varchar) AS returnflag FROM tpch.tiny.lineitem", tableName, additionalParameters), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("select max(linestatus), max(shipmode), count(returnflag) from %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testInsertIntoPartitionedCsvTable() {
        this.testInsertIntoPartitionedCsvTable("");
    }

    @Test(groups={"storage_formats"})
    public void testInsertIntoPartitionedCsvTableWithCustomProperties() {
        this.testInsertIntoPartitionedCsvTable(", csv_escape = 'e', csv_separator = 's', csv_quote = 'q'");
    }

    private void testInsertIntoPartitionedCsvTable(String additionalParameters) {
        String tableName = "test_partitioned_csv_table";
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s(   linestatus    varchar,   shipinstruct  varchar,   shipmode      varchar,   comment       varchar,   returnflag    varchar,   suppkey       bigint) WITH (format='CSV' %s, partitioned_by = ARRAY['suppkey'])", tableName, additionalParameters), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT linestatus, shipinstruct, shipmode, comment, returnflag, suppkey FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("select max(linestatus), max(shipinstruct), max(shipmode), max(suppkey) from %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testCreatePartitionedCsvTableAs() {
        this.testCreatePartitionedCsvTableAs("storage_formats_test_create_table_as_select_partitioned_csv", "");
    }

    @Test(groups={"storage_formats"})
    public void testCreatePartitionedCsvTableAsWithCustomParamters() {
        this.testCreatePartitionedCsvTableAs("storage_formats_test_create_table_as_select_partitioned_csv_with_custom_parameters", ", csv_escape = 'e', csv_separator='s', csv_quote='q'");
    }

    private void testCreatePartitionedCsvTableAs(String tableName, String additionalParameters) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s WITH (format='CSV', partitioned_by = ARRAY['suppkey'] %s) AS SELECT cast(shipmode AS varchar) AS shipmode, cast(comment AS varchar) AS comment, suppkey FROM tpch.tiny.lineitem", tableName, additionalParameters), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("select max(shipmode), max(comment), sum(suppkey) from %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void assertSelect(String query, String tableName) {
        QueryResult expected = QueryExecutor.query((String)String.format(query, "tpch.tiny.lineitem"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        List expectedRows = (List)expected.rows().stream().map(columns -> QueryAssert.Row.row((Object[])columns.toArray())).collect(ImmutableList.toImmutableList());
        QueryResult actual = QueryExecutor.query((String)String.format(query, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actual).hasColumns(expected.getColumnTypes()).containsOnly(expectedRows);
    }
}

