/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Assertions;
import io.prestosql.jdbc.PrestoArray;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.context.ThreadLocalTestContextHolder;
import io.prestosql.tempto.fulfillment.table.MutableTableRequirement;
import io.prestosql.tempto.fulfillment.table.MutableTablesState;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableHandle;
import io.prestosql.tempto.fulfillment.table.TableInstance;
import io.prestosql.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.JdbcDriverUtils;
import io.prestosql.tests.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.JDBCType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCoercion
extends ProductTest {
    public static final HiveTableDefinition HIVE_COERCION_TEXTFILE = TestHiveCoercion.tableDefinitionBuilder("TEXTFILE", Optional.empty(), Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_PARQUET = TestHiveCoercion.tableDefinitionBuilder("PARQUET", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_AVRO = TestHiveCoercion.avroTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercion.tableDefinitionBuilder("ORC", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCTEXT = TestHiveCoercion.tableDefinitionBuilder("RCFILE", Optional.of("RCTEXT"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCBINARY = TestHiveCoercion.tableDefinitionBuilder("RCFILE", Optional.of("RCBINARY"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe'")).setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat, Optional<String> recommendTableName, Optional<String> rowFormat) {
        String tableName = String.format("%s_hive_coercion", recommendTableName.orElse(fileFormat).toLowerCase(Locale.ENGLISH));
        String floatType = fileFormat.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "FLOAT";
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(    tinyint_to_smallint        TINYINT,    tinyint_to_int             TINYINT,    tinyint_to_bigint          TINYINT,    smallint_to_int            SMALLINT,    smallint_to_bigint         SMALLINT,    int_to_bigint              INT,    bigint_to_varchar          BIGINT,    float_to_double            " + floatType + ",    double_to_float            DOUBLE,    shortdecimal_to_shortdecimal          DECIMAL(10,2),    shortdecimal_to_longdecimal          DECIMAL(10,2),    longdecimal_to_shortdecimal          DECIMAL(20,12),    longdecimal_to_longdecimal          DECIMAL(20,12),    float_to_decimal            " + floatType + ",    double_to_decimal           DOUBLE,    decimal_to_float            DECIMAL(10,5),    decimal_to_double           DECIMAL(10,5),    row_to_row                 STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT>,    list_to_list               ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,    map_to_map                 MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: " + floatType + ">>) PARTITIONED BY (id BIGINT) " + rowFormat.map(s -> String.format("ROW FORMAT %s ", s)).orElse("") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder avroTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"avro_hive_coercion").setCreateTableDDLTemplate("CREATE TABLE %NAME%(    int_to_bigint              INT,    float_to_double            DOUBLE) PARTITIONED BY (id BIGINT) STORED AS AVRO");
    }

    @Requires(value={TextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionTextFile() {
        this.doTestHiveCoercion(HIVE_COERCION_TEXTFILE);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={RcTextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcText() {
        this.doTestHiveCoercion(HIVE_COERCION_RCTEXT);
    }

    @Requires(value={RcBinaryRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcBinary() {
        this.doTestHiveCoercion(HIVE_COERCION_RCBINARY);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionParquet() {
        this.doTestHiveCoercion(HIVE_COERCION_PARQUET);
    }

    @Requires(value={AvroRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionAvro() {
        String tableName = TestHiveCoercion.mutableTableInstanceOf((TableDefinition)HIVE_COERCION_AVRO).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (id=1) VALUES(2323, 0.5),(-2323, -1.5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW COLUMNS FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
        QueryResult queryResult = QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.DOUBLE, JDBCType.BIGINT});
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2323L, 0.5, 1}), QueryAssert.Row.row((Object[])new Object[]{-2323L, -1.5, 1})});
    }

    private void doTestHiveCoercion(HiveTableDefinition tableDefinition) {
        ImmutableList expectedRows;
        String tableName = TestHiveCoercion.mutableTableInstanceOf((TableDefinition)tableDefinition).getNameInDatabase();
        String floatToDoubleType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "REAL";
        String floatToDecimalVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.12300";
        String decimalToFloatVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.124";
        QueryExecutor.query((String)String.format("INSERT INTO %s\nVALUES\n  (TINYINT '-1', TINYINT '2', TINYINT '-3', SMALLINT '100', SMALLINT '-101', INTEGER '2323', 12345, REAL '0.5', DOUBLE '0.5', DECIMAL '12345678.12', DECIMAL '12345678.12', DECIMAL '12345678.123456123456', DECIMAL '12345678.123456123456', %s '12345.12345', DOUBLE '12345.12345', DECIMAL '12345.12345', DECIMAL '12345.12345',\n    CAST(ROW ('as is', -1, 100, 2323, 12345) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT)),\n    ARRAY [CAST(ROW (2, -101, 12345, 'removed') AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],\n    MAP (ARRAY [TINYINT '2'], ARRAY [CAST(ROW (-3, 2323, REAL '0.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %s))]),\n    1),\n  (TINYINT '1', TINYINT '-2', NULL, SMALLINT '-100', SMALLINT '101', INTEGER '-2323', -12345, REAL '-1.5', DOUBLE '-1.5', DECIMAL '-12345678.12', DECIMAL '-12345678.12', DECIMAL '-12345678.123456123456', DECIMAL '-12345678.123456123456', %s '-12345.12345', DOUBLE '-12345.12345', DECIMAL '-12345.12345', DECIMAL '-12345.12345',\n    CAST(ROW (NULL, 1, -100, -2323, -12345) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT)),\n    ARRAY [CAST(ROW (-2, 101, -12345, NULL) AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],\n    MAP (ARRAY [TINYINT '-2'], ARRAY [CAST(ROW (null, -2323, REAL '-1.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %s))]),\n    1)", tableName, floatToDoubleType, floatToDoubleType, floatToDoubleType, floatToDoubleType), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveCoercion.alterTableColumnTypes(tableName);
        this.assertProperAlteredTableSchema(tableName);
        QueryResult queryResult = QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(queryResult, tableName);
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{-1, 2, -3L, 100, -101L, 2323L, "12345", 0.5, 0.5, new BigDecimal("12345678.1200"), new BigDecimal("12345678.1200"), new BigDecimal("12345678.12"), new BigDecimal("12345678.12345612345600"), new BigDecimal(floatToDecimalVal), new BigDecimal("12345.12345"), Float.valueOf(Float.parseFloat(decimalToFloatVal)), 12345.12345, TestHiveCoercion.asMap("keep", "as is", "ti2si", (short)-1, "si2int", 100, "int2bi", 2323L, "bi2vc", "12345"), ImmutableList.of(TestHiveCoercion.asMap("ti2int", 2, "si2bi", -101L, "bi2vc", "12345")), TestHiveCoercion.asMap(2, TestHiveCoercion.asMap("ti2bi", -3L, "int2bi", 2323L, "float2double", 0.5, "add", null)), 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, -2, null, -100, 101L, -2323L, "-12345", -1.5, -1.5, new BigDecimal("-12345678.1200"), new BigDecimal("-12345678.1200"), new BigDecimal("-12345678.12"), new BigDecimal("-12345678.12345612345600"), new BigDecimal("-" + floatToDecimalVal), new BigDecimal("-12345.12345"), Float.valueOf(-Float.parseFloat(decimalToFloatVal)), -12345.12345, TestHiveCoercion.asMap("keep", null, "ti2si", (short)1, "si2int", -100, "int2bi", -2323L, "bi2vc", "-12345"), ImmutableList.of(TestHiveCoercion.asMap("ti2int", -2, "si2bi", 101L, "bi2vc", "-12345")), ImmutableMap.of((Object)-2, TestHiveCoercion.asMap("ti2bi", null, "int2bi", -2323L, "float2double", -1.5, "add", null)), 1}));
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{-1, 2, -3L, 100, -101L, 2323L, "12345", 0.5, 0.5, 1.234567812E7, 1.234567812E7, 1.234567812E7, 1.2345678123456124E7, Float.valueOf(Float.parseFloat(floatToDecimalVal)), 12345.12345, Float.valueOf(Float.parseFloat(decimalToFloatVal)), 12345.12345, "[\"as is\",-1,100,2323,\"12345\"]", "[[2,-101,\"12345\"]]", "{\"2\":[-3,2323,0.5,null]}", 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, -2, null, -100, 101L, -2323L, "-12345", -1.5, -1.5, -1.234567812E7, -1.234567812E7, -1.234567812E7, -1.2345678123456124E7, Float.valueOf(-Float.parseFloat(floatToDecimalVal)), -12345.12345, Float.valueOf(-Float.parseFloat(decimalToFloatVal)), -12345.12345, "[null,1,-100,-2323,\"-12345\"]", "[[-2,101,\"-12345\"]]", "{\"-2\":[null,-2323,-1.5,null]}", 1}));
        } else {
            throw new IllegalStateException();
        }
        QueryAssert.assertThat((QueryResult)queryResult.project(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 21})).containsOnly(TestHiveCoercion.project((List<QueryAssert.Row>)expectedRows, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 21));
        Assertions.assertEqualsIgnoreOrder((Iterable)queryResult.column(18), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 18), (String)"row_to_row field is not equal");
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            Assertions.assertEqualsIgnoreOrder(TestHiveCoercion.extract(queryResult.column(19)), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 19), (String)"list_to_list field is not equal");
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            Assertions.assertEqualsIgnoreOrder((Iterable)queryResult.column(19), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 19), (String)"list_to_list field is not equal");
        } else {
            throw new IllegalStateException();
        }
        Assertions.assertEqualsIgnoreOrder((Iterable)queryResult.column(20), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 20), (String)"map_to_map field is not equal");
    }

    private void assertProperAlteredTableSchema(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "real";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW COLUMNS FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_shortdecimal", "decimal(18,4)"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_longdecimal", "decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_shortdecimal", "decimal(12,2)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_longdecimal", "decimal(38,14)"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_decimal", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_decimal", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"row_to_row", "row(keep varchar, ti2si smallint, si2int integer, int2bi bigint, bi2vc varchar)"}), QueryAssert.Row.row((Object[])new Object[]{"list_to_list", "array(row(ti2int integer, si2bi bigint, bi2vc varchar))"}), QueryAssert.Row.row((Object[])new Object[]{"map_to_map", "map(integer, row(ti2bi bigint, int2bi bigint, float2double double, add tinyint))"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
    }

    private void assertColumnTypes(QueryResult queryResult, String tableName) {
        JDBCType floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.REAL;
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.VARCHAR, JDBCType.DOUBLE, floatType, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, floatType, JDBCType.DOUBLE, JDBCType.JAVA_OBJECT, JDBCType.ARRAY, JDBCType.JAVA_OBJECT, JDBCType.BIGINT});
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.VARCHAR, JDBCType.DOUBLE, floatType, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.DECIMAL, floatType, JDBCType.DOUBLE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.BIGINT});
        } else {
            throw new IllegalStateException();
        }
    }

    private static void alterTableColumnTypes(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "float";
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_smallint tinyint_to_smallint smallint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_int tinyint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_bigint tinyint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_int smallint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_bigint smallint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_varchar bigint_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_float double_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_shortdecimal shortdecimal_to_shortdecimal DECIMAL(18,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_longdecimal shortdecimal_to_longdecimal DECIMAL(20,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_shortdecimal longdecimal_to_shortdecimal DECIMAL(12,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_longdecimal longdecimal_to_longdecimal DECIMAL(38,14)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_decimal float_to_decimal DECIMAL(10,5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_decimal double_to_decimal DECIMAL(10,5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_float decimal_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_double decimal_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN row_to_row row_to_row struct<keep:string, ti2si:smallint, si2int:int, int2bi:bigint, bi2vc:string>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN list_to_list list_to_list array<struct<ti2int:int, si2bi:bigint, bi2vc:string>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN map_to_map map_to_map map<int,struct<ti2bi:bigint, int2bi:bigint, float2double:double, add:tinyint>>", tableName), new QueryExecutor.QueryParam[0]);
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition) {
        if (tableDefinition.getDatabase().isPresent()) {
            return TestHiveCoercion.mutableTableInstanceOf(tableDefinition, (String)tableDefinition.getDatabase().get());
        }
        return TestHiveCoercion.mutableTableInstanceOf(TestHiveCoercion.tableHandleInSchema(tableDefinition));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition, String database) {
        return TestHiveCoercion.mutableTableInstanceOf(TestHiveCoercion.tableHandleInSchema(tableDefinition).inDatabase(database));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableHandle tableHandle) {
        return ((MutableTablesState)ThreadLocalTestContextHolder.testContext().getDependency(MutableTablesState.class)).get(tableHandle);
    }

    private static TableHandle tableHandleInSchema(TableDefinition tableDefinition) {
        TableHandle tableHandle = TableHandle.tableHandle((String)tableDefinition.getName());
        if (tableDefinition.getSchema().isPresent()) {
            tableHandle = tableHandle.inSchema((String)tableDefinition.getSchema().get());
        }
        return tableHandle;
    }

    private static Map<Object, Object> asMap(Object ... objects) {
        Assert.assertEquals((int)(objects.length % 2), (int)0, (String)"number of objects must be even");
        HashMap<Object, Object> struct = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            struct.put(objects[i], objects[i + 1]);
        }
        return struct;
    }

    private static QueryAssert.Row project(QueryAssert.Row row, int ... columns) {
        return new QueryAssert.Row(Arrays.stream(columns).mapToObj(column -> row.getValues().get(column - 1)).collect(Collectors.toList()));
    }

    private static List<QueryAssert.Row> project(List<QueryAssert.Row> rows, int ... columns) {
        return (List)rows.stream().map(row -> TestHiveCoercion.project(row, columns)).collect(ImmutableList.toImmutableList());
    }

    private static List<?> column(List<QueryAssert.Row> rows, int sqlColumnIndex) {
        return rows.stream().map(row -> TestHiveCoercion.project(row, sqlColumnIndex).getValues().get(0)).collect(Collectors.toList());
    }

    private static List<List<?>> extract(List<PrestoArray> arrays) {
        return (List)arrays.stream().map(prestoArray -> Arrays.asList((Object[])prestoArray.getArray())).collect(ImmutableList.toImmutableList());
    }

    public static final class AvroRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_AVRO).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcBinaryRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCBINARY).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcTextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCTEXT).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class TextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_TEXTFILE).withState(MutableTableRequirement.State.CREATED).build();
        }
    }
}

