/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.JdbcDriverUtils;
import io.prestosql.tests.utils.QueryExecutors;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveStorageFormats
extends ProductTest {
    private static final String TPCH_SCHEMA = "tiny";

    @DataProvider(name="storage_formats")
    public static Object[][] storageFormats() {
        return new StorageFormat[][]{{TestHiveStorageFormats.storageFormat("ORC", (Map<String, String>)ImmutableMap.of((Object)"hive.orc_optimized_writer_validate", (Object)"true"))}, {TestHiveStorageFormats.storageFormat("PARQUET")}, {TestHiveStorageFormats.storageFormat("RCBINARY", (Map<String, String>)ImmutableMap.of((Object)"hive.rcfile_optimized_writer_validate", (Object)"true"))}, {TestHiveStorageFormats.storageFormat("RCTEXT", (Map<String, String>)ImmutableMap.of((Object)"hive.rcfile_optimized_writer_validate", (Object)"true"))}, {TestHiveStorageFormats.storageFormat("SEQUENCEFILE")}, {TestHiveStorageFormats.storageFormat("TEXTFILE")}, {TestHiveStorageFormats.storageFormat("AVRO")}};
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testInsertIntoTable(StorageFormat storageFormat) {
        TestHiveStorageFormats.setRole("admin");
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_insert_into_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTable = String.format("CREATE TABLE %s(   orderkey      BIGINT,   partkey       BIGINT,   suppkey       BIGINT,   linenumber    INTEGER,   quantity      DOUBLE,   extendedprice DOUBLE,   discount      DOUBLE,   tax           DOUBLE,   linestatus    VARCHAR,   shipinstruct  VARCHAR,   shipmode      VARCHAR,   comment       VARCHAR,   returnflag    VARCHAR) WITH (format='%s')", tableName, storageFormat.getName());
        QueryExecutor.query((String)createTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String insertInto = String.format("INSERT INTO %s SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice, discount, tax, linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA);
        QueryExecutor.query((String)insertInto, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertSelect("select sum(tax), sum(discount), sum(linenumber) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testCreateTableAs(StorageFormat storageFormat) {
        TestHiveStorageFormats.setRole("admin");
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_create_table_as_select_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTableAsSelect = String.format("CREATE TABLE %s WITH (format='%s') AS SELECT partkey, suppkey, extendedprice FROM tpch.%s.lineitem", tableName, storageFormat.getName(), TPCH_SCHEMA);
        QueryExecutor.query((String)createTableAsSelect, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertSelect("select sum(extendedprice), sum(suppkey), count(partkey) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testInsertIntoPartitionedTable(StorageFormat storageFormat) {
        TestHiveStorageFormats.setRole("admin");
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_insert_into_partitioned_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTable = String.format("CREATE TABLE %s(   orderkey      BIGINT,   partkey       BIGINT,   suppkey       BIGINT,   linenumber    INTEGER,   quantity      DOUBLE,   extendedprice DOUBLE,   discount      DOUBLE,   tax           DOUBLE,   linestatus    VARCHAR,   shipinstruct  VARCHAR,   shipmode      VARCHAR,   comment       VARCHAR,   returnflag    VARCHAR) WITH (format='%s', partitioned_by = ARRAY['returnflag'])", tableName, storageFormat.getName());
        QueryExecutor.query((String)createTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String insertInto = String.format("INSERT INTO %s SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice, discount, tax, linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA);
        QueryExecutor.query((String)insertInto, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertSelect("select sum(tax), sum(discount), sum(length(returnflag)) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testCreatePartitionedTableAs(StorageFormat storageFormat) {
        TestHiveStorageFormats.setRole("admin");
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_create_table_as_select_partitioned_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTableAsSelect = String.format("CREATE TABLE %s WITH (format='%s', partitioned_by = ARRAY['returnflag']) AS SELECT tax, discount, returnflag FROM tpch.%s.lineitem", tableName, storageFormat.getName(), TPCH_SCHEMA);
        QueryExecutor.query((String)createTableAsSelect, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertSelect("select sum(tax), sum(discount), sum(length(returnflag)) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testSnappyCompressedParquetTableCreatedInHive() {
        String tableName = "table_created_in_hive_parquet";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (   c_bigint BIGINT,   c_varchar VARCHAR(255))STORED AS PARQUET TBLPROPERTIES(\"parquet.compression\"=\"SNAPPY\")", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES(1, 'test data')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test data"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    private static void assertSelect(String query, String tableName) {
        QueryResult expected = QueryExecutor.query((String)String.format(query, "tpch.tiny.lineitem"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        List expectedRows = (List)expected.rows().stream().map(columns -> QueryAssert.Row.row((Object[])columns.toArray())).collect(ImmutableList.toImmutableList());
        QueryResult actual = QueryExecutor.query((String)String.format(query, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actual).hasColumns(expected.getColumnTypes()).containsExactly(expectedRows);
    }

    private static void setRole(String role) {
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        try {
            JdbcDriverUtils.setRole(connection, role);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setSessionProperties(StorageFormat storageFormat) {
        TestHiveStorageFormats.setSessionProperties(storageFormat.getSessionProperties());
    }

    private static void setSessionProperties(Map<String, String> sessionProperties) {
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        try {
            JdbcDriverUtils.setSessionProperty(connection, "task_writer_count", "4");
            JdbcDriverUtils.setSessionProperty(connection, "redistribute_writes", "false");
            for (Map.Entry<String, String> sessionProperty : sessionProperties.entrySet()) {
                JdbcDriverUtils.setSessionProperty(connection, sessionProperty.getKey(), sessionProperty.getValue());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static StorageFormat storageFormat(String name) {
        return TestHiveStorageFormats.storageFormat(name, (Map<String, String>)ImmutableMap.of());
    }

    private static StorageFormat storageFormat(String name, Map<String, String> sessionProperties) {
        return new StorageFormat(name, sessionProperties);
    }

    private static class StorageFormat {
        private final String name;
        private final Map<String, String> sessionProperties;

        private StorageFormat(String name, Map<String, String> sessionProperties) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getSessionProperties() {
            return this.sessionProperties;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("sessionProperties", this.sessionProperties).toString();
        }
    }
}

