/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestSqlStandardAccessControlChecks
extends ProductTest {
    private String tableName = "alice_owned_table";
    private String viewName = "alice_owned_view";
    private QueryExecutor aliceExecutor;
    private QueryExecutor bobExecutor;
    private QueryExecutor charlieExecutor;
    private QueryExecutor caseSensitiveUserNameExecutor;

    @BeforeTestWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToPresto("alice@presto");
        this.bobExecutor = QueryExecutors.connectToPresto("bob@presto");
        this.charlieExecutor = QueryExecutors.connectToPresto("charlie@presto");
        this.caseSensitiveUserNameExecutor = QueryExecutors.connectToPresto("CaseSensitiveUserName@presto");
        this.aliceExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE TABLE %s(month bigint, day bigint) WITH (partitioned_by = ARRAY['day'])", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("DROP VIEW IF EXISTS %s", this.viewName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE VIEW %s AS SELECT month, day FROM %s", this.viewName, this.tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSelect() {
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.viewName));
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.viewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSelectFromPartitions() {
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM \"%s$partitions\"", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s$partitions", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM \"%s$partitions\"", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlInsert() {
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (3, 22)", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot insert into table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT INSERT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (3, 22)", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlDelete() {
        this.aliceExecutor.executeQuery(String.format("INSERT INTO %s VALUES (4, 13)", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("DELETE FROM %s WHERE day=4", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot delete from table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT DELETE ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(String.format("DELETE FROM %s", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlCreateTableAsSelect() {
        String createTableAsSelect = "bob_create_table_as_select";
        this.bobExecutor.executeQuery("DROP TABLE IF EXISTS " + createTableAsSelect, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM %s", createTableAsSelect, this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM %s", createTableAsSelect, this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", createTableAsSelect), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.bobExecutor.executeQuery("DROP TABLE " + createTableAsSelect, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlDropTable() {
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("DROP TABLE %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot drop table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("DROP TABLE %s", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage("does not exist");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlAlterTable() {
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(2);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("ALTER TABLE %s ADD COLUMN year bigint", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot add a column to table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("ALTER TABLE %s ADD COLUMN year bigint", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(3);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlCreateView() {
        String viewName = "bob_view";
        String selectTableSql = String.format("SELECT * FROM %s", this.tableName);
        String createViewSql = String.format("CREATE VIEW %s AS %s", viewName, selectTableSql);
        this.bobExecutor.executeQuery(String.format("DROP VIEW IF EXISTS %s", viewName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery("DROP VIEW IF EXISTS " + viewName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(createViewSql, new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(createViewSql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat(() -> this.charlieExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", viewName));
        this.bobExecutor.executeQuery(String.format("GRANT SELECT ON %s TO charlie", viewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.charlieExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: View owner 'bob' cannot create view that selects from default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("REVOKE SELECT ON %s FROM bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob WITH GRANT OPTION", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat((QueryResult)this.charlieExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.bobExecutor.executeQuery("DROP VIEW " + viewName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlDropView() {
        String viewName = "alice_view_for_drop";
        this.aliceExecutor.executeQuery("DROP VIEW IF EXISTS " + viewName, new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE VIEW %s AS SELECT * FROM %s", viewName, this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("DROP VIEW %s", viewName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot drop view default.%s", viewName));
        this.aliceExecutor.executeQuery(String.format("DROP VIEW %s", viewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).failsWithMessage("does not exist");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSelectWithCaseSensitiveUserName() {
        QueryAssert.assertThat(() -> this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        QueryExecutors.onHive().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("GRANT SELECT ON TABLE %s TO USER casesensitiveusername", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        QueryExecutors.onHive().executeQuery(String.format("GRANT SELECT ON TABLE %s TO USER CaseSensitiveUserName", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat(() -> this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.viewName));
        QueryExecutors.onHive().executeQuery(String.format("GRANT SELECT ON TABLE %s TO USER CaseSensitiveUserName", this.viewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlShowColumns() {
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot show columns of table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(2);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlFilterColumns() {
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM information_schema.columns WHERE table_name = '%s'", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM information_schema.columns WHERE table_name = '%s'", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(2);
    }
}

