/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.inject.Inject;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.fulfillment.table.hive.HiveDataSource;
import io.prestosql.tempto.fulfillment.table.hive.InlineDataSource;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.internal.hadoop.hdfs.HdfsDataSourceWriter;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import org.testng.annotations.Test;

public class TestSyncPartitionMetadata
extends ProductTest {
    private static final String WAREHOUSE_DIRECTORY_PATH = "/user/hive/warehouse/";
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    private HdfsDataSourceWriter hdfsDataSourceWriter;

    @Test(groups={"hive_partitioning", "smoke"})
    public void testAddPartition() {
        String tableName = "test_sync_partition_metadata_add_partition";
        TestSyncPartitionMetadata.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'ADD')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}));
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT payload, x, y FROM " + tableName + " ORDER BY 1, 2, 3 ASC"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Partition location does not exist: hdfs://hadoop-master:9000/user/hive/warehouse/" + tableName + "/x=b/y=2");
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke"})
    public void testDropPartition() {
        String tableName = "test_sync_partition_metadata_drop_partition";
        TestSyncPartitionMetadata.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'DROP')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}));
        TestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}));
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke"})
    public void testFullSyncPartition() {
        String tableName = "test_sync_partition_metadata_add_drop_partition";
        TestSyncPartitionMetadata.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}));
        TestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}), QueryAssert.Row.row((Object[])new Object[]{42, "f", "9"}));
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke"})
    public void testInvalidSyncMode() {
        String tableName = "test_repair_invalid_mode";
        TestSyncPartitionMetadata.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'INVALID')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessageMatching("java.sql.SQLException: Query failed (.*): Invalid partition metadata sync mode: INVALID");
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    private static void prepare(HdfsClient hdfsClient, HdfsDataSourceWriter hdfsDataSourceWriter, String tableName) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + " (payload bigint, x varchar, y varchar) WITH (format = 'ORC', partitioned_by = ARRAY[ 'x', 'y' ])"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1, 'a', '1'), (2, 'b', '2')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String tableLocation = WAREHOUSE_DIRECTORY_PATH + tableName;
        hdfsClient.delete(tableLocation + "/x=b/y=2");
        hdfsClient.createDirectory(tableLocation + "/x=f/y=9");
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)"io/prestosql/tests/hive/data/single_int_column/data.orc");
        hdfsDataSourceWriter.ensureDataOnHdfs(tableLocation + "/x=f/y=9", dataSource);
        hdfsClient.createDirectory(tableLocation + "/x=d");
        hdfsClient.createDirectory(tableLocation + "/y=3/x=h");
        hdfsClient.createDirectory(tableLocation + "/y=3");
        hdfsClient.createDirectory(tableLocation + "/xyz");
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}));
    }

    private static void cleanup(String tableName) {
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void assertPartitions(String tableName, QueryAssert.Row ... rows) {
        QueryResult partitionListResult = QueryExecutor.query((String)("SELECT * FROM \"" + tableName + "$partitions\""), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactly(rows);
    }

    private static void assertData(String tableName, QueryAssert.Row ... rows) {
        QueryResult dataResult = QueryExecutor.query((String)("SELECT payload, x, y FROM " + tableName + " ORDER BY 1, 2, 3 ASC"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)dataResult).containsExactly(rows);
    }
}

