/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.inject.Inject;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.MutableTableRequirement;
import io.prestosql.tempto.fulfillment.table.MutableTablesState;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.HiveDataSource;
import io.prestosql.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestosql.tempto.fulfillment.table.hive.InlineDataSource;
import io.prestosql.tempto.query.QueryExecutionException;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.util.Locale;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTablePartitioningSelect
extends ProductTest
implements RequirementsProvider {
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONEND_TEXTFILE = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("TEXTFILE", Optional.of("DELIMITED FIELDS TERMINATED BY '|'"));
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_ORC = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("ORC", Optional.empty());
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_RCFILE = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("RCFILE", Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'"));
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_PARQUET = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("PARQUET", Optional.empty());
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_AVRO = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("AVRO", Optional.of("SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'"));
    private static final String TABLE_NAME = "test_table";
    @Inject
    private MutableTablesState tablesState;

    private static HiveTableDefinition singleIntColumnPartitionedTableDefinition(String fileFormat, Optional<String> serde) {
        String tableName = fileFormat.toLowerCase(Locale.ENGLISH) + "_single_int_column_partitioned";
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)("io/prestosql/tests/hive/data/single_int_column/data." + fileFormat.toLowerCase(Locale.ENGLISH)));
        HiveDataSource invalidData = InlineDataSource.createStringDataSource((String)tableName, (String)"INVALID DATA");
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate(TestTablePartitioningSelect.buildSingleIntColumnPartitionedTableDDL(fileFormat, serde)).addPartition("part_col = 1", invalidData).addPartition("part_col = 2", dataSource).build();
    }

    private static String buildSingleIntColumnPartitionedTableDDL(String fileFormat, Optional<String> rowFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE %EXTERNAL% TABLE %NAME%(");
        sb.append("   col INT");
        sb.append(") ");
        sb.append("PARTITIONED BY (part_col INT) ");
        if (rowFormat.isPresent()) {
            sb.append("ROW FORMAT ").append(rowFormat.get());
        }
        sb.append(" STORED AS " + fileFormat);
        return sb.toString();
    }

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.allOf((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONEND_TEXTFILE, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_ORC, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_RCFILE, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_PARQUET, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_AVRO, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED)});
    }

    @Test
    public void testSelectPartitionedHiveTableDifferentFormats() {
        String tableNameInDatabase = this.tablesState.get(TABLE_NAME).getNameInDatabase();
        String selectFromOnePartitionsSql = "SELECT * FROM " + tableNameInDatabase + " WHERE part_col = 2";
        QueryResult onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42, 2})});
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42, 2}), QueryAssert.Row.row((Object[])new Object[]{null, 1})});
        }
        catch (QueryExecutionException queryExecutionException) {
            // empty catch block
        }
    }
}

