/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.jdbc;

import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.ImmutableLdapObjectDefinitions;
import io.prestosql.tests.TpchTableResults;
import io.prestosql.tests.jdbc.LdapJdbcTests;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LdapSimbaJdbcTests
extends LdapJdbcTests {
    private static final String JDBC_URL_FORMAT = "jdbc:presto://%s;AuthenticationType=LDAP Authentication;SSLTrustStorePath=%s;SSLTrustStorePwd=%s;AllowSelfSignedServerCert=1;AllowHostNameCNMismatch=1";
    private static final String SSL_CERTIFICATE_ERROR = "[Teradata][Presto](100140) SSL certificate error: Keystore was tampered with, or password was incorrect.";
    private static final String INVALID_CREDENTIALS_ERROR = "[Teradata][Presto](100240) Authentication failed: Invalid credentials.";
    private static final String MALFORMED_CREDENTIALS_ERROR = "[Teradata][Presto](100240) Authentication failed: Malformed decoded credentials.";
    private static final String UNAUTHORIZED_USER_ERROR = "[Teradata][Presto](100240) Authentication failed: Unauthorized user.";
    private static final String INVALID_SSL_PROPERTY = "[Teradata][Presto](100200) Connection string is invalid: SSL value is not valid for given AuthenticationType.";

    @Override
    protected String getLdapUrlFormat() {
        return JDBC_URL_FORMAT;
    }

    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldRunQueryWithLdap() throws SQLException {
        QueryAssert.assertThat((QueryResult)this.executeLdapQuery("select * from tpch.tiny.nation", this.ldapUserName, this.ldapUserPassword)).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapUserInChildGroup() {
        String name = (String)ImmutableLdapObjectDefinitions.CHILD_GROUP_USER.getAttributes().get("cn");
        this.expectQueryToFailForUserNotInGroup(name);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapUserInParentGroup() {
        String name = (String)ImmutableLdapObjectDefinitions.PARENT_GROUP_USER.getAttributes().get("cn");
        this.expectQueryToFailForUserNotInGroup(name);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForOrphanLdapUser() {
        String name = (String)ImmutableLdapObjectDefinitions.ORPHAN_USER.getAttributes().get("cn");
        this.expectQueryToFailForUserNotInGroup(name);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForWrongLdapPassword() {
        this.expectQueryToFail(this.ldapUserName, "wrong_password", INVALID_CREDENTIALS_ERROR);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForWrongLdapUser() {
        this.expectQueryToFail("invalid_user", this.ldapUserPassword, INVALID_CREDENTIALS_ERROR);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForEmptyUser() {
        this.expectQueryToFail("", this.ldapUserPassword, MALFORMED_CREDENTIALS_ERROR);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapWithoutPassword() {
        this.expectQueryToFail(this.ldapUserName, "", MALFORMED_CREDENTIALS_ERROR);
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapWithoutSsl() {
        try {
            DriverManager.getConnection(this.getLdapUrl() + ";SSL=0", this.ldapUserName, this.ldapUserPassword);
            Assert.fail();
        }
        catch (SQLException exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)INVALID_SSL_PROPERTY);
        }
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailForIncorrectTrustStore() {
        try {
            String url = String.format(JDBC_URL_FORMAT, this.prestoServer(), this.ldapTruststorePath, "wrong_password");
            Connection connection = DriverManager.getConnection(url, this.ldapUserName, this.ldapUserPassword);
            Statement statement = connection.createStatement();
            statement.executeQuery("select * from tpch.tiny.nation");
            Assert.fail();
        }
        catch (SQLException exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)SSL_CERTIFICATE_ERROR);
        }
    }

    @Test(groups={"ldap", "simba_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailForUserWithColon() {
        this.expectQueryToFail("UserWith:Colon", this.ldapUserPassword, MALFORMED_CREDENTIALS_ERROR);
    }

    private void expectQueryToFailForUserNotInGroup(String user) {
        this.expectQueryToFail(user, this.ldapUserPassword, UNAUTHORIZED_USER_ERROR);
    }
}

