/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaMessage;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaMessageContentsBuilder;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.prestosql.tempto.fulfillment.table.kafka.ListKafkaDataSource;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.testng.annotations.Test;

public class KafkaAvroSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String ALL_DATATYPES_AVRO_TABLE_NAME = "product_tests.all_datatypes_avro";
    private static final String ALL_DATATYPES_AVRO_TOPIC_NAME = "all_datatypes_avro";
    private static final String ALL_DATATYPE_SCHEMA_PATH = "/docker/volumes/conf/presto/etc/catalog/kafka/all_datatypes_avro_schema.avsc";
    private static final String ALL_NULL_AVRO_TABLE_NAME = "product_tests.all_null_avro";
    private static final String ALL_NULL_AVRO_TOPIC_NAME = "all_null_avro";
    private static final String STRUCTURAL_AVRO_TABLE_NAME = "product_tests.structural_datatype_avro";
    private static final String STRUCTURAL_AVRO_TOPIC_NAME = "structural_datatype_avro";
    private static final String STRUCTURAL_SCHEMA_PATH = "/docker/volumes/conf/presto/etc/catalog/kafka/structural_datatype_avro_schema.avsc";

    private static Requirement createAvroTable(String schemaPath, String tableName, String topicName, ImmutableMap<String, Object> record) {
        try {
            Schema schema = new Schema.Parser().parse(new File(schemaPath));
            byte[] avroData = KafkaAvroSmokeTest.convertRecordToAvro(schema, record);
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition(tableName, topicName, (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of((Object)new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendBytes(avroData).build()))), 1, 1));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] convertRecordToAvro(Schema schema, Map<String, Object> values) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GenericData.Record record = new GenericData.Record(schema);
        values.forEach((arg_0, arg_1) -> ((GenericData.Record)record).put(arg_0, arg_1));
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            dataFileWriter.create(schema, (OutputStream)outputStream);
            dataFileWriter.append((Object)record);
            dataFileWriter.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to convert to Avro.", e);
        }
        return outputStream.toByteArray();
    }

    @Test(groups={"kafka"})
    @Requires(value={AllDataTypesAvroTable.class})
    public void testSelectPrimitiveDataType() throws SQLException {
        QueryResult queryResult = QueryExecutor.query((String)String.format("select * from %s.%s", KAFKA_CATALOG, ALL_DATATYPES_AVRO_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"foobar", 127, 234.567, true})});
    }

    @Test(groups={"kafka"})
    @Requires(value={NullDataAvroTable.class})
    public void testNullType() throws SQLException {
        QueryResult queryResult = QueryExecutor.query((String)String.format("select * from %s.%s", KAFKA_CATALOG, ALL_NULL_AVRO_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null, null})});
    }

    @Test(groups={"kafka"})
    @Requires(value={StructuralDataTypeTable.class})
    public void testSelectStructuralDataType() throws SQLException {
        QueryResult queryResult = QueryExecutor.query((String)String.format("SELECT a[1], a[2], m['key1'] FROM (SELECT c_array as a, c_map as m FROM %s.%s) t", KAFKA_CATALOG, STRUCTURAL_AVRO_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{100, 102, "value1"})});
    }

    private static class StructuralDataTypeTable
    implements RequirementsProvider {
        private StructuralDataTypeTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            ImmutableMap record = ImmutableMap.of((Object)"a_array", (Object)ImmutableList.of((Object)100L, (Object)102L), (Object)"a_map", (Object)ImmutableMap.of((Object)"key1", (Object)"value1"));
            return KafkaAvroSmokeTest.createAvroTable(KafkaAvroSmokeTest.STRUCTURAL_SCHEMA_PATH, KafkaAvroSmokeTest.STRUCTURAL_AVRO_TABLE_NAME, KafkaAvroSmokeTest.STRUCTURAL_AVRO_TOPIC_NAME, (ImmutableMap<String, Object>)record);
        }
    }

    private static class NullDataAvroTable
    implements RequirementsProvider {
        private NullDataAvroTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return KafkaAvroSmokeTest.createAvroTable(KafkaAvroSmokeTest.ALL_DATATYPE_SCHEMA_PATH, KafkaAvroSmokeTest.ALL_NULL_AVRO_TABLE_NAME, KafkaAvroSmokeTest.ALL_NULL_AVRO_TOPIC_NAME, (ImmutableMap<String, Object>)ImmutableMap.of());
        }
    }

    private static class AllDataTypesAvroTable
    implements RequirementsProvider {
        private AllDataTypesAvroTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            ImmutableMap record = ImmutableMap.of((Object)"a_varchar", (Object)"foobar", (Object)"a_bigint", (Object)127L, (Object)"a_double", (Object)234.567, (Object)"a_boolean", (Object)true);
            return KafkaAvroSmokeTest.createAvroTable(KafkaAvroSmokeTest.ALL_DATATYPE_SCHEMA_PATH, KafkaAvroSmokeTest.ALL_DATATYPES_AVRO_TABLE_NAME, KafkaAvroSmokeTest.ALL_DATATYPES_AVRO_TOPIC_NAME, (ImmutableMap<String, Object>)record);
        }
    }
}

