/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.mysql;

import io.airlift.log.Logger;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class CreateTableAsSelect
extends ProductTest {
    private static final String TABLE_NAME = "test.nation_tmp";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTable() {
        try {
            QueryExecutors.onMySql().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            Logger.get(((Object)((Object)this)).getClass()).warn((Throwable)e, "failed to drop table");
        }
    }

    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    @Test(groups={"jdbc", "mysql"})
    public void testCreateTableAsSelect() {
        QueryResult queryResult = QueryExecutor.query((String)String.format("CREATE TABLE mysql.%s AS SELECT * FROM nation", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
    }
}

