/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.querystats;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Exposed;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.initialization.AutoModuleProvider;
import io.prestosql.tempto.initialization.SuiteModuleProvider;
import io.prestosql.tests.querystats.HttpQueryStatsClient;
import io.prestosql.tests.querystats.QueryStatsClient;
import java.net.URI;
import javax.inject.Named;

@AutoModuleProvider
public class QueryStatsClientModuleProvider
implements SuiteModuleProvider {
    private static HttpQueryStatsClient httpQueryStatsClient;

    public Module getModule(final Configuration configuration) {
        return new PrivateModule(){

            protected void configure() {
                this.bind(ObjectMapper.class).toProvider(ObjectMapperProvider.class);
            }

            @Inject
            @Provides
            @Exposed
            QueryStatsClient getQueryStatsClient(ObjectMapper objectMapper, @Named(value="databases.presto.server_address") String serverAddress) {
                if (httpQueryStatsClient == null) {
                    HttpClientConfig httpClientConfig = new HttpClientConfig();
                    httpClientConfig.setKeyStorePath((String)configuration.getString("databases.presto.https_keystore_path").orElse(null));
                    httpClientConfig.setKeyStorePassword((String)configuration.getString("databases.presto.https_keystore_password").orElse(null));
                    httpQueryStatsClient = new HttpQueryStatsClient((HttpClient)new JettyHttpClient(httpClientConfig), objectMapper, URI.create(serverAddress));
                }
                return httpQueryStatsClient;
            }
        };
    }
}

