/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.sqlserver;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.sqlserver.SqlServerTpchTableDefinitions;
import org.testng.annotations.Test;

public class TestInvalidSelect
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)SqlServerTpchTableDefinitions.NATION);
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNonExistentTable() {
        String tableName = String.format("%s.%s.%s", "sqlserver", "dbo", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Table %s does not exist", tableName));
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNonExistentSchema() {
        String tableName = String.format("%s.%s.%s", "sqlserver", "does_not_exist", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Schema does_not_exist does not exist");
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNonExistentColumn() {
        String tableName = String.format("%s.%s.%s", "sqlserver", "dbo", SqlServerTpchTableDefinitions.NATION.getName());
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT bogus FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'bogus' cannot be resolved");
    }
}

