/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.sqlserver;

import io.airlift.log.Logger;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.TpchTableResults;
import io.prestosql.tests.sqlserver.SqlServerDataTypesTableDefinition;
import io.prestosql.tests.sqlserver.SqlServerTpchTableDefinitions;
import io.prestosql.tests.utils.QueryExecutors;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestSelect
extends ProductTest
implements RequirementsProvider {
    private static final Logger log = Logger.get(TestSelect.class);
    private static final String CTAS_TABLE_NAME = "create_table_as_select";
    private static final String NATION_TABLE_NAME = String.format("%s.%s.%s", "sqlserver", "dbo", SqlServerTpchTableDefinitions.NATION.getName());
    private static final String CREATE_TABLE_AS_SELECT = String.format("%s.%s.%s", "sqlserver", "dbo", "create_table_as_select");
    private static final String ALL_TYPES_TABLE_NAME = String.format("%s.%s.%s", "sqlserver", "dbo", SqlServerDataTypesTableDefinition.SQLSERVER_ALL_TYPES.getName());

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)SqlServerTpchTableDefinitions.NATION), TableRequirements.immutableTable((TableDefinition)SqlServerDataTypesTableDefinition.SQLSERVER_ALL_TYPES)});
    }

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTables() {
        try {
            QueryExecutors.onPresto().executeQuery(String.format("DROP TABLE IF EXISTS %s", CREATE_TABLE_AS_SELECT), new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "failed to drop table");
        }
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testSelectNation() {
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM " + NATION_TABLE_NAME, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNationSelfInnerJoin() {
        String sql = String.format("SELECT n1.n_name, n2.n_regionkey FROM %s n1 JOIN %s n2 ON n1.n_nationkey = n2.n_regionkey WHERE n1.n_nationkey=3", NATION_TABLE_NAME, NATION_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testNationJoinRegion() {
        String sql = String.format("SELECT c.n_name, t.name FROM %s c JOIN tpch.tiny.region t ON c.n_regionkey = t.regionkey WHERE c.n_nationkey=3", NATION_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", "AMERICA"})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testAllDatatypes() {
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery("SELECT * FROM " + ALL_TYPES_TABLE_NAME, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.TINYINT, JDBCType.DOUBLE, JDBCType.REAL, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.DATE, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.TIMESTAMP, JDBCType.DOUBLE, JDBCType.REAL}).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Long.MIN_VALUE, (short)Short.MIN_VALUE, Integer.MIN_VALUE, (byte)-128, Double.MIN_VALUE, Float.valueOf(-3.4E38f), "\u0000   ", "\u0000", "\u0000", "\u0000    ", "\u0000", "\u0000", Date.valueOf("1953-01-02"), Timestamp.valueOf("1953-01-01 00:00:00.000"), Timestamp.valueOf("2001-01-01 00:00:00.123"), Timestamp.valueOf("1970-01-01 00:00:00.000"), Timestamp.valueOf("1960-01-01 00:00:00"), Double.MIN_VALUE, Float.valueOf(-3.4E38f)}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, (short)Short.MAX_VALUE, Integer.MAX_VALUE, (byte)127, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), "abcd", "abcdef", "abcd", "abcde", "abcdefg", "abcd", Date.valueOf("9999-12-31"), Timestamp.valueOf("9999-12-31 23:59:59.997"), Timestamp.valueOf("9999-12-31 23:59:59.999"), Timestamp.valueOf("9999-12-31 23:59:59.999"), Timestamp.valueOf("2079-06-06 00:00:00"), 1.2345678912345676E10, Float.valueOf(1.2345679E7f)}), QueryAssert.Row.row((Object[])Collections.nCopies(19, null).toArray())});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testCreateTableAsSelect() {
        QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM %s", CREATE_TABLE_AS_SELECT, NATION_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult queryResult = QueryExecutors.onSqlServer().executeQuery(String.format("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM %s.%s.%s", "master", "dbo", CTAS_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }
}

