/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.utils;

import io.airlift.log.Logger;
import io.prestosql.jdbc.PrestoConnection;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcDriverUtils {
    private static final Logger LOGGER = Logger.get(JdbcDriverUtils.class);
    private static final String IS_NUMERIC_REGEX = "-?\\d*[\\.\\d]*";

    public static void setRole(Connection connection, String role) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SET ROLE " + role);
        }
    }

    public static String getSessionProperty(Connection connection, String key) throws SQLException {
        return JdbcDriverUtils.getSessionProperty(connection, key, "Value");
    }

    public static String getSessionPropertyDefault(Connection connection, String key) throws SQLException {
        return JdbcDriverUtils.getSessionProperty(connection, key, "Default");
    }

    private static String getSessionProperty(Connection connection, String key, String valueType) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("SHOW SESSION");
            while (rs.next()) {
                if (!rs.getString("Name").equals(key)) continue;
                String string = rs.getString(valueType);
                return string;
            }
        }
        return null;
    }

    public static void setSessionProperty(Connection connection, String key, String value) throws SQLException {
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            PrestoConnection prestoConnection = connection.unwrap(PrestoConnection.class);
            prestoConnection.setSessionProperty(key, value);
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            try (Statement statement = connection.createStatement();){
                if (JdbcDriverUtils.shouldValueBeQuoted(value)) {
                    value = "'" + value + "'";
                }
                statement.execute(String.format("set session %s=%s", key, value));
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private static boolean shouldValueBeQuoted(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.matches(IS_NUMERIC_REGEX)) {
            return false;
        }
        try {
            new BigDecimal(value);
            return false;
        }
        catch (NumberFormatException e) {
            LOGGER.info("'%s' is not a number", new Object[]{value, e});
            return true;
        }
    }

    public static void resetSessionProperty(Connection connection, String key) throws SQLException {
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            JdbcDriverUtils.setSessionProperty(connection, key, JdbcDriverUtils.getSessionPropertyDefault(connection, key));
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            try (Statement statement = connection.createStatement();){
                statement.execute("RESET SESSION " + key);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public static boolean usingPrestoJdbcDriver(Connection connection) {
        return JdbcDriverUtils.getClassNameForJdbcDriver(connection).equals("io.prestosql.jdbc.PrestoConnection");
    }

    public static boolean usingTeradataJdbcDriver(Connection connection) {
        return JdbcDriverUtils.getClassNameForJdbcDriver(connection).startsWith("com.teradata.presto.");
    }

    public static boolean usingTeradataJdbc4Driver(Connection connection) {
        return JdbcDriverUtils.getClassNameForJdbcDriver(connection).startsWith("com.teradata.presto.jdbc.jdbc4.");
    }

    private static String getClassNameForJdbcDriver(Connection connection) {
        return connection.getClass().getCanonicalName();
    }

    private JdbcDriverUtils() {
    }
}

