/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import io.prestosql.tempto.query.QueryResult;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.testng.Assert;

public class QueryAssertions {
    public static void assertContainsEventually(Supplier<QueryResult> all, QueryResult expectedSubset, Duration timeout) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                QueryAssertions.assertContains(all.get(), expectedSubset);
                return;
            }
            catch (AssertionError e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    public static void assertContains(QueryResult all, QueryResult expectedSubset) {
        for (Object row : expectedSubset.rows()) {
            if (all.rows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getRowsCount(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all.rows(), (int)100)), expectedSubset.getRowsCount(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset.rows(), (int)100))));
        }
    }

    private QueryAssertions() {
    }
}

