/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.cli;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.testing.TempFile;
import io.prestosql.cli.Presto;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.ImmutableTableRequirement;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.process.CliProcess;
import io.prestosql.tests.cli.PrestoCliLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPrestoCli
extends PrestoCliLauncher
implements RequirementsProvider {
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_authentication")
    private boolean kerberosAuthentication;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_principal")
    private String kerberosPrincipal;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_keytab")
    private String kerberosKeytab;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_config_path")
    private String kerberosConfigPath;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_service_name")
    private String kerberosServiceName;
    @Inject(optional=true)
    @Named(value="databases.presto.https_keystore_path")
    private String keystorePath;
    @Inject(optional=true)
    @Named(value="databases.presto.https_keystore_password")
    private String keystorePassword;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_use_canonical_hostname")
    private boolean kerberosUseCanonicalHostname;
    @Inject
    @Named(value="databases.presto.jdbc_user")
    private String jdbcUser;

    @Override
    @AfterTestWithContext
    public void stopPresto() throws InterruptedException {
        super.stopPresto();
    }

    public Requirement getRequirements(Configuration configuration) {
        return new ImmutableTableRequirement((TableDefinition)TpchTableDefinitions.NATION);
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldDisplayVersion() throws IOException {
        this.launchPrestoCli("--version");
        String version = (String)MoreObjects.firstNonNull((Object)Presto.class.getPackage().getImplementationVersion(), (Object)"(version unknown)");
        Assertions.assertThat((List)this.presto.readRemainingOutputLines()).containsExactly((Object[])new String[]{"Presto CLI " + version});
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunQuery() throws IOException {
        this.launchPrestoCliWithServerArgument(new String[0]);
        this.presto.waitForPrompt();
        this.presto.getProcessInput().println("select * from hive.default.nation;");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunBatchQuery() throws Exception {
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        this.presto.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExecuteEmptyListOfStatements() throws Exception {
        this.launchPrestoCliWithServerArgument("--execute", "");
        Assert.assertTrue((boolean)CliProcess.trimLines((List)this.presto.readRemainingOutputLines()).isEmpty());
        this.presto.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldUseCatalogAndSchemaOptions() throws Exception {
        this.launchPrestoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        this.presto.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunQueryFromFile() throws Exception {
        try (TempFile file = new TempFile();){
            Files.write((CharSequence)"select * from hive.default.nation;\n", (File)file.file(), (Charset)StandardCharsets.UTF_8);
            this.launchPrestoCliWithServerArgument("--file", file.file().getAbsolutePath());
            Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
            this.presto.waitForWithTimeoutAndKill();
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExitOnErrorFromExecute() throws IOException {
        String sql = "select * from hive.default.nations; select * from hive.default.nation;";
        this.launchPrestoCliWithServerArgument("--execute", sql);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).isEmpty();
        Assertions.assertThatThrownBy(() -> this.presto.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExitOnErrorFromFile() throws IOException {
        try (TempFile file = new TempFile();){
            Files.write((CharSequence)"select * from hive.default.nations;\nselect * from hive.default.nation;\n", (File)file.file(), (Charset)StandardCharsets.UTF_8);
            this.launchPrestoCliWithServerArgument("--file", file.file().getAbsolutePath());
            Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).isEmpty();
            Assertions.assertThatThrownBy(() -> this.presto.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldNotExitOnErrorFromExecute() throws IOException {
        String sql = "select * from hive.default.nations; select * from hive.default.nation;";
        this.launchPrestoCliWithServerArgument("--execute", sql, "--ignore-errors");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        Assertions.assertThatThrownBy(() -> this.presto.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldNotExitOnErrorFromFile() throws IOException {
        try (TempFile file = new TempFile();){
            Files.write((CharSequence)"select * from hive.default.nations;\nselect * from hive.default.nation;\n", (File)file.file(), (Charset)StandardCharsets.UTF_8);
            this.launchPrestoCliWithServerArgument("--file", file.file().getAbsolutePath(), "--ignore-errors");
            Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
            Assertions.assertThatThrownBy(() -> this.presto.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldHandleSession() throws IOException {
        this.launchPrestoCliWithServerArgument(new String[0]);
        this.presto.waitForPrompt();
        this.presto.getProcessInput().println("use hive.default;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"USE"});
        this.presto.getProcessInput().println("select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
        this.presto.getProcessInput().println("show session;");
        Assertions.assertThat(TestPrestoCli.squeezeLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"join_distribution_type|AUTOMATIC|AUTOMATIC|varchar|Join distribution type. Possible values: [BROADCAST, PARTITIONED, AUTOMATIC]"});
        this.presto.getProcessInput().println("set session join_distribution_type = 'BROADCAST';");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"SET SESSION"});
        this.presto.getProcessInput().println("show session;");
        Assertions.assertThat(TestPrestoCli.squeezeLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"join_distribution_type|BROADCAST|AUTOMATIC|varchar|Join distribution type. Possible values: [BROADCAST, PARTITIONED, AUTOMATIC]"});
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldHandleTransaction() throws IOException {
        this.launchPrestoCliWithServerArgument(new String[0]);
        this.presto.waitForPrompt();
        this.presto.getProcessInput().println("use hive.default;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"USE"});
        this.presto.getProcessInput().println("start transaction;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"START TRANSACTION"});
        this.presto.getProcessInput().println("create table txn_test (x bigint);");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"CREATE TABLE"});
        this.presto.getProcessInput().println("select foo;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).extracting(TestPrestoCli::removePrefix).contains((Object[])new String[]{"line 1:8: Column 'foo' cannot be resolved"});
        this.presto.getProcessInput().println("select * from nation;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).extracting(TestPrestoCli::removePrefix).contains((Object[])new String[]{"Current transaction is aborted, commands ignored until end of transaction block"});
        this.presto.getProcessInput().println("rollback;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"ROLLBACK"});
        this.presto.getProcessInput().println("select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
        this.presto.getProcessInput().println("show tables;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).doesNotContain((Object[])new String[]{"txn_test"});
        this.presto.getProcessInput().println("start transaction;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"START TRANSACTION"});
        this.presto.getProcessInput().println("create table txn_test1 (x bigint);");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"CREATE TABLE"});
        this.presto.getProcessInput().println("create table txn_test2 (x bigint);");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"CREATE TABLE"});
        this.presto.getProcessInput().println("commit;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"COMMIT"});
        this.presto.getProcessInput().println("show tables;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"txn_test1", "txn_test2"});
    }

    @Test(groups={"authorization", "profile_specific_tests"}, timeOut=300000L)
    public void testSetRole() throws IOException {
        this.launchPrestoCliWithServerArgument(new String[0]);
        this.presto.waitForPrompt();
        this.presto.getProcessInput().println("use hive.default;");
        Assertions.assertThat(this.presto.readLinesUntilPrompt()).contains((Object[])new String[]{"USE"});
        this.presto.getProcessInput().println("show current roles;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"public"});
        this.presto.getProcessInput().println("set role admin;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"SET ROLE"});
        this.presto.getProcessInput().println("show current roles;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"public", "admin"});
        this.presto.getProcessInput().println("set role none;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).contains((Object[])new String[]{"SET ROLE"});
        this.presto.getProcessInput().println("show current roles;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).doesNotContain((Object[])new String[]{"admin"});
    }

    private void launchPrestoCliWithServerArgument(String ... arguments) throws IOException {
        ImmutableList.Builder prestoClientOptions = ImmutableList.builder();
        prestoClientOptions.add((Object[])new String[]{"--server", this.serverAddress});
        prestoClientOptions.add((Object[])new String[]{"--user", this.jdbcUser});
        if (this.keystorePath != null) {
            prestoClientOptions.add((Object[])new String[]{"--keystore-path", this.keystorePath});
        }
        if (this.keystorePassword != null) {
            prestoClientOptions.add((Object[])new String[]{"--keystore-password", this.keystorePassword});
        }
        if (this.kerberosAuthentication) {
            Objects.requireNonNull(this.kerberosPrincipal, "databases.presto.cli_kerberos_principal is null");
            Objects.requireNonNull(this.kerberosKeytab, "databases.presto.cli_kerberos_keytab is null");
            Objects.requireNonNull(this.kerberosServiceName, "databases.presto.cli_kerberos_service_name is null");
            Objects.requireNonNull(this.kerberosConfigPath, "databases.presto.cli_kerberos_config_path is null");
            prestoClientOptions.add((Object[])new String[]{"--krb5-principal", this.kerberosPrincipal});
            prestoClientOptions.add((Object[])new String[]{"--krb5-keytab-path", this.kerberosKeytab});
            prestoClientOptions.add((Object[])new String[]{"--krb5-remote-service-name", this.kerberosServiceName});
            prestoClientOptions.add((Object[])new String[]{"--krb5-config-path", this.kerberosConfigPath});
            if (!this.kerberosUseCanonicalHostname) {
                prestoClientOptions.add((Object)"--krb5-disable-remote-service-hostname-canonicalization");
            }
        }
        prestoClientOptions.add((Object[])arguments);
        this.launchPrestoCli((List<String>)prestoClientOptions.build());
    }

    private static String removePrefix(String line) {
        int i = line.indexOf(58);
        return i >= 0 ? line.substring(i + 1).trim() : line;
    }

    public static List<String> squeezeLines(List<String> lines) {
        return lines.stream().map(line -> line.replaceAll(" +\\| +", "|").trim()).collect(Collectors.toList());
    }
}

