/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.inject.Module;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.initialization.SuiteModuleProvider;
import io.prestosql.tests.hive.HiveVersion;
import io.prestosql.tests.utils.QueryExecutors;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Optional;
import javax.inject.Singleton;

public class HiveVersionProvider {
    private Optional<HiveVersion> hiveVersion = Optional.empty();

    public synchronized HiveVersion getHiveVersion() {
        this.hiveVersion = this.hiveVersion.or(() -> Optional.of(HiveVersionProvider.detectHiveVersion()));
        return this.hiveVersion.get();
    }

    private static HiveVersion detectHiveVersion() {
        try {
            DatabaseMetaData metaData = QueryExecutors.onHive().getConnection().getMetaData();
            return HiveVersion.createFromString(metaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ModuleProvider
    implements SuiteModuleProvider {
        public Module getModule(Configuration configuration) {
            return binder -> binder.bind(HiveVersionProvider.class).in(Singleton.class);
        }
    }
}

