/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.inject.name.Named;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.testng.annotations.Test;

public class TestAvroSymlinkInputFormat
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @BeforeTestWithContext
    public void setup() throws Exception {
        this.hdfsClient.createDirectory(this.warehouseDirectory + "/TestAvroSymlinkInputFormat/data");
        this.saveResourceOnHdfs("avro/original_data.avro", this.warehouseDirectory + "/TestAvroSymlinkInputFormat/data/original_data.avro");
    }

    @AfterTestWithContext
    public void cleanup() {
        this.hdfsClient.delete(this.warehouseDirectory + "/TestAvroSymlinkInputFormat");
    }

    private void saveResourceOnHdfs(String resource, String location) throws IOException {
        this.hdfsClient.delete(location);
        try (InputStream inputStream = Files.newInputStream(Paths.get("/docker/presto-product-tests", resource), new OpenOption[0]);){
            this.hdfsClient.saveFile(location, inputStream);
        }
    }

    @Test(groups={"avro", "storage_formats"})
    public void testSymlinkTable() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_symlink", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_avro_symlink ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' WITH SERDEPROPERTIES ('avro.schema.literal'='{\"namespace\": \"io.prestosql.tests.hive\",\"name\": \"test_avro_symlink\",\"type\": \"record\",\"fields\": [{ \"name\":\"string_col\", \"type\":\"string\"},{ \"name\":\"int_col\", \"type\":\"int\" }]}') STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(this.warehouseDirectory + "/test_avro_schema_symlink/symlink.txt");
        this.hdfsClient.saveFile(this.warehouseDirectory + "/test_avro_symlink/symlink.txt", String.format("hdfs://%s/TestAvroSymlinkInputFormat/data/original_data.avro", this.warehouseDirectory));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_avro_symlink", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"someValue", 1})});
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_symlink", new QueryExecutor.QueryParam[0]);
    }
}

