/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestCompression
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.ORDERS);
    }

    @Test(groups={"hive_compression", "skip_on_cdh"})
    public void testReadLzop() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_read_lzop", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onHive().executeQuery("SET hive.exec.compress.output=true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("SET mapreduce.output.fileoutputformat.compress=true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("SET mapreduce.output.fileoutputformat.compress.codec=com.hadoop.compression.lzo.LzopCodec", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("CREATE TABLE test_read_lzop STORED AS TEXTFILE AS SELECT * FROM orders", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT count(*) FROM test_read_lzop", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1500000})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT sum(o_orderkey) FROM test_read_lzop", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4499987250000L})});
            Assertions.assertThat((String)((String)QueryExecutors.onPresto().executeQuery("SELECT \"$path\" FROM test_read_lzop LIMIT 1", new QueryExecutor.QueryParam[0]).row(0).get(0))).endsWith((CharSequence)".lzo");
        }
        finally {
            QueryExecutors.onHive().executeQuery("RESET", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_read_lzop", new QueryExecutor.QueryParam[0]);
        }
    }
}

