/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.MutableTableRequirement;
import io.prestosql.tempto.fulfillment.table.MutableTablesState;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.TpchTableResults;
import io.prestosql.tests.hive.BucketingType;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.utils.QueryExecutors;
import io.prestosql.tests.utils.TableDefinitionUtils;
import java.sql.JDBCType;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestHiveBucketedTables
extends HiveProductTest
implements RequirementsProvider {
    private static final Logger log = Logger.get(TestHiveBucketedTables.class);
    public static final HiveTableDefinition BUCKETED_NATION = TestHiveBucketedTables.bucketTableDefinition("bucket_nation", false, false);
    public static final HiveTableDefinition BUCKETED_NATION_PREPARED = HiveTableDefinition.builder((String)"bucket_nation_prepared").setCreateTableDDLTemplate("Table %NAME% should be only used with CTAS queries").setNoData().build();
    public static final HiveTableDefinition BUCKETED_SORTED_NATION = TestHiveBucketedTables.bucketTableDefinition("bucketed_sorted_nation", true, false);
    public static final HiveTableDefinition BUCKETED_PARTITIONED_NATION = TestHiveBucketedTables.bucketTableDefinition("bucketed_partitioned_nation", false, true);

    private static HiveTableDefinition bucketTableDefinition(String tableName, boolean sorted, boolean partitioned) {
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(n_nationkey     BIGINT,n_name          STRING,n_regionkey     BIGINT,n_comment       STRING) " + (partitioned ? "PARTITIONED BY (part_key STRING) " : " ") + "CLUSTERED BY (n_regionkey) " + (sorted ? "SORTED BY (n_regionkey) " : " ") + "INTO 2 BUCKETS ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' TBLPROPERTIES ('bucketing_version'='1')").setNoData().build();
    }

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)BUCKETED_PARTITIONED_NATION).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)BUCKETED_NATION).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)BUCKETED_NATION_PREPARED).withState(MutableTableRequirement.State.PREPARED).build(), MutableTableRequirement.builder((TableDefinition)BUCKETED_SORTED_NATION).withState(MutableTableRequirement.State.CREATED).build(), TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION)});
    }

    @Test
    public void testSelectStar() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"big_query"})
    public void testIgnorePartitionBucketingIfNotBucketed() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s NOT CLUSTERED", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(DISTINCT n_nationkey), count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25, 50})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test(groups={"big_query"})
    public void testAllowMultipleFilesPerBucket() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        for (int i = 0; i < 3; ++i) {
            TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert'");
        }
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(DISTINCT n_nationkey), count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25, 75})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
    }

    @Test
    public void testSelectAfterMultipleInserts() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT n_regionkey, count(*) FROM %s GROUP BY n_regionkey", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 10}), QueryAssert.Row.row((Object[])new Object[]{1, 10}), QueryAssert.Row.row((Object[])new Object[]{2, 10}), QueryAssert.Row.row((Object[])new Object[]{3, 10}), QueryAssert.Row.row((Object[])new Object[]{4, 10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey", tableName, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{500})});
    }

    @Test
    public void testSelectAfterMultipleInsertsForSortedTable() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_SORTED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT n_regionkey, count(*) FROM %s GROUP BY n_regionkey", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 10}), QueryAssert.Row.row((Object[])new Object[]{1, 10}), QueryAssert.Row.row((Object[])new Object[]{2, 10}), QueryAssert.Row.row((Object[])new Object[]{3, 10}), QueryAssert.Row.row((Object[])new Object[]{4, 10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey", tableName, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{500})});
    }

    @Test
    public void testSelectAfterMultipleInsertsForPartitionedTable() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1 AND part_key = 'insert_1'", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT n_regionkey, count(*) FROM %s WHERE part_key = 'insert_2' GROUP BY n_regionkey", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 10}), QueryAssert.Row.row((Object[])new Object[]{1, 10}), QueryAssert.Row.row((Object[])new Object[]{2, 10}), QueryAssert.Row.row((Object[])new Object[]{3, 10}), QueryAssert.Row.row((Object[])new Object[]{4, 10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey", tableName, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2000})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey WHERE n.part_key = 'insert_1'", tableName, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000})});
    }

    @Test
    public void testSelectFromEmptyBucketedTableEmptyTablesAllowed() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
    }

    @Test
    public void testSelectFromIncompleteBucketedTableEmptyTablesAllowed() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateRowToHiveTable(tableName, (List<String>)ImmutableList.of((Object)"2", (Object)"'name'", (Object)"2", (Object)"'comment'"), Optional.empty());
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) from %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select n_nationkey from %s where n_regionkey = 2", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test
    public void testInsertPartitionedBucketed() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_NATION_PREPARED).getNameInDatabase();
        String ctasQuery = "CREATE TABLE %s WITH (bucket_count = 4, bucketed_by = ARRAY['n_regionkey'], partitioned_by = ARRAY['part_key']) AS SELECT n_nationkey, n_name, n_regionkey, n_comment, n_name as part_key FROM %s";
        QueryExecutor.query((String)String.format(ctasQuery, tableName, TpchTableDefinitions.NATION.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE part_key='ALGERIA'", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey=0 AND part_key='ALGERIA'", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
    }

    @Test
    public void testCreatePartitionedBucketedTableAsSelect() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT n_nationkey, n_name, n_regionkey, n_comment, n_name FROM %s", tableName, TpchTableDefinitions.NATION.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE part_key='ALGERIA'", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey=0 AND part_key='ALGERIA'", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
    }

    @Test
    public void testInsertIntoBucketedTables() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT * FROM %s", tableName, TpchTableDefinitions.NATION.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT * FROM %s", tableName, TpchTableDefinitions.NATION.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{50})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
    }

    @Test
    public void testCreateBucketedTableAsSelect() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_NATION_PREPARED).getNameInDatabase();
        QueryExecutor.query((String)String.format("CREATE TABLE %s WITH (bucket_count = 10, bucketed_by = ARRAY['n_regionkey']) AS SELECT * FROM %s", tableName, TpchTableDefinitions.NATION.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).matches(TpchTableResults.PRESTO_NATION_RESULT);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
    }

    @Test
    public void testBucketingVersion() {
        String value = "prestosql rocks";
        String bucketV1 = "000001_0";
        String bucketV2Standard = "000003_0";
        String bucketV2DirectInsert = "bucket_00003";
        ImmutableList bucketV1NameOptions = ImmutableList.of((Object)bucketV1);
        ImmutableList bucketV2NameOptions = ImmutableList.of((Object)bucketV2Standard, (Object)bucketV2DirectInsert);
        this.testBucketingVersion(BucketingType.BUCKETED_DEFAULT, value, false, (List<String>)(this.getHiveVersionMajor() < 3 ? bucketV1NameOptions : bucketV2NameOptions));
        this.testBucketingVersion(BucketingType.BUCKETED_DEFAULT, value, true, (List<String>)(this.getHiveVersionMajor() < 3 ? bucketV1NameOptions : bucketV2NameOptions));
        this.testBucketingVersion(BucketingType.BUCKETED_V1, value, false, (List<String>)bucketV1NameOptions);
        this.testBucketingVersion(BucketingType.BUCKETED_V1, value, true, (List<String>)bucketV1NameOptions);
        if (this.getHiveVersionMajor() >= 3) {
            this.testBucketingVersion(BucketingType.BUCKETED_V2, value, false, (List<String>)bucketV2NameOptions);
            this.testBucketingVersion(BucketingType.BUCKETED_V2, value, true, (List<String>)bucketV2NameOptions);
        }
    }

    private void testBucketingVersion(BucketingType bucketingType, String value, boolean insertWithPresto, List<String> expectedFileNameOptions) {
        log.info("Testing with bucketingType=%s, value='%s', insertWithPresto=%s, expectedFileNamePossibilites=%s", new Object[]{bucketingType, value, insertWithPresto, expectedFileNameOptions});
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_bucketing_version", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_bucketing_version(a string) " + bucketingType.getHiveClustering("a", 4) + " STORED AS ORC " + this.hiveTableProperties(bucketingType), new QueryExecutor.QueryParam[0]);
        if (insertWithPresto) {
            QueryExecutors.onPresto().executeQuery("INSERT INTO test_bucketing_version(a) VALUES (?)", new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)value)});
        } else {
            QueryExecutors.onHive().executeQuery("SET hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO test_bucketing_version(a) VALUES ('" + value + "')", new QueryExecutor.QueryParam[0]);
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT a, regexp_extract(\"$path\", '^.*/([^_/]+_[^_/]+)(_[^/]+)?$', 1) FROM test_bucketing_version", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{value, QueryAssert.anyOf((Object[])expectedFileNameOptions.toArray())})});
    }

    private String hiveTableProperties(BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.add((Object)"'transactional'='false'");
        tableProperties.addAll(bucketingType.getHiveTableProperties());
        return "TBLPROPERTIES(" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)tableProperties.build()) + ")";
    }

    private static void populateRowToHiveTable(String destination, List<String> values, Optional<String> partition) {
        String queryStatement = String.format("INSERT INTO TABLE %s" + (partition.isPresent() ? String.format(" PARTITION (%s) ", partition.get()) : " ") + "SELECT %s from (select 'foo') x", destination, String.join((CharSequence)",", values));
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(queryStatement, new QueryExecutor.QueryParam[0]);
    }

    private static void populateHivePartitionedTable(String destination, String source, String partition) {
        String queryStatement = String.format("INSERT INTO TABLE %s PARTITION (%s) SELECT * FROM %s", destination, partition, source);
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(queryStatement, new QueryExecutor.QueryParam[0]);
    }

    private static void populateHiveTable(String destination, String source) {
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT * FROM %s", destination, source), new QueryExecutor.QueryParam[0]);
    }
}

