/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.collect.Iterables;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCaching
extends ProductTest {
    private static final int NUMBER_OF_FILES = 5;

    @Test(groups={"hive_caching", "profile_specific_tests"})
    public void testReadFromCache() {
        this.testReadFromTable("table1");
        this.testReadFromTable("table2");
    }

    private void testReadFromTable(String tableNameSuffix) {
        String cachedTableName = "hive.default.test_cache_read" + tableNameSuffix;
        String nonCachedTableName = "hivenoncached.default.test_cache_read" + tableNameSuffix;
        QueryAssert.Row[] tableData = this.createTestTable(nonCachedTableName);
        QueryResult beforeCacheStats = this.getCacheStats();
        long initialRemoteReads = this.getRemoteReads(beforeCacheStats);
        long initialCachedReads = this.getCachedReads(beforeCacheStats);
        long initialNonLocalReads = this.getNonLocalReads(beforeCacheStats);
        long initialAsyncDownloadedMb = this.getAsyncDownloadedMb();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + cachedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(tableData);
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(20.0, TimeUnit.SECONDS), () -> {
            QueryResult afterQueryCacheStats = this.getCacheStats();
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(this.getAsyncDownloadedMb()), (Comparable)Long.valueOf(initialAsyncDownloadedMb + 5L));
            Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getRemoteReads(afterQueryCacheStats)), (Comparable)Long.valueOf(initialRemoteReads));
            Assert.assertEquals((long)this.getCachedReads(afterQueryCacheStats), (long)initialCachedReads);
            Assert.assertEquals((long)this.getNonLocalReads(afterQueryCacheStats), (long)initialNonLocalReads);
        });
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            QueryResult beforeQueryCacheStats = this.getCacheStats();
            long beforeQueryCachedReads = this.getCachedReads(beforeQueryCacheStats);
            long beforeQueryRemoteReads = this.getRemoteReads(beforeQueryCacheStats);
            long beforeQueryNonLocalReads = this.getNonLocalReads(beforeQueryCacheStats);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + cachedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(tableData);
            QueryResult afterQueryCacheStats = this.getCacheStats();
            Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getCachedReads(afterQueryCacheStats)), (Comparable)Long.valueOf(beforeQueryCachedReads));
            Assert.assertEquals((long)this.getRemoteReads(afterQueryCacheStats), (long)beforeQueryRemoteReads);
            Assert.assertEquals((long)this.getNonLocalReads(afterQueryCacheStats), (long)beforeQueryNonLocalReads);
        });
        QueryExecutor.query((String)("DROP TABLE " + nonCachedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private QueryAssert.Row[] createTestTable(String tableName) {
        StringBuilder randomDataBuilder = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 500000; ++i) {
            randomDataBuilder.append(random.nextInt(10));
        }
        String randomData = randomDataBuilder.toString();
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + " (col varchar) WITH (format='TEXTFILE')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        for (int i = 0; i < 5; ++i) {
            QueryExecutor.query((String)("INSERT INTO " + tableName + " SELECT format('%1$s%1$s%1$s%1$s%1$s', '" + randomData + "')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        }
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{randomData.repeat(5)});
        return Collections.nCopies(5, row).toArray(new QueryAssert.Row[0]);
    }

    private QueryResult getCacheStats() {
        return QueryExecutor.query((String)"SELECT sum(cachedreads) as cachedreads, sum(remotereads) as remotereads, sum(nonlocalreads) as nonlocalreads FROM jmx.current.\"rubix:catalog=hive,name=stats\"", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private long getCachedReads(QueryResult queryResult) {
        return (Long)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("cachedreads").get() - 1);
    }

    private long getRemoteReads(QueryResult queryResult) {
        return (Long)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("remotereads").get() - 1);
    }

    private long getNonLocalReads(QueryResult queryResult) {
        return (Long)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("nonlocalreads").get() - 1);
    }

    private long getAsyncDownloadedMb() {
        return (Long)((List)Iterables.getOnlyElement((Iterable)QueryExecutor.query((String)"SELECT sum(Count) FROM jmx.current.\"metrics:name=rubix.bookkeeper.count.async_downloaded_mb\"", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).rows())).get(0);
    }
}

