/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveCreateTable
extends ProductTest {
    @Test(groups={"storage_formats"})
    public void testCreateTable() throws SQLException {
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_create_table(a bigint, b varchar, c smallint) WITH (format='ORC')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("INSERT INTO test_create_table(a, b, c) VALUES (NULL, NULL, NULL), (-42, 'abc', SMALLINT '-127'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz', SMALLINT '32767')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_create_table", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc", -127}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz", Short.MAX_VALUE})});
        Assertions.assertThat(TestHiveCreateTable.getTableProperty("test_create_table", "transactional")).isIn(new Object[]{Optional.empty(), Optional.of("false")});
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_create_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testCreateTableAsSelect() throws SQLException {
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_create_table_as_select WITH (format='ORC') AS SELECT * FROM (VALUES   (NULL, NULL, NULL),   (-42, 'abc', SMALLINT '-127'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz', SMALLINT '32767')) t(a, b, c)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_create_table_as_select", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc", -127}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz", Short.MAX_VALUE})});
        Assertions.assertThat(TestHiveCreateTable.getTableProperty("test_create_table_as_select", "transactional")).isIn(new Object[]{Optional.empty(), Optional.of("false")});
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_create_table_as_select", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hdp3_only", "profile_specific_tests"})
    public void testVerifyEnvironmentHiveTransactionalByDefault() throws SQLException {
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_hive_transactional_by_default(a bigint) STORED AS ORC", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(TestHiveCreateTable.getTableProperty("test_hive_transactional_by_default", "transactional")).contains((Object)"true");
        QueryExecutors.onHive().executeQuery("DROP TABLE test_hive_transactional_by_default", new QueryExecutor.QueryParam[0]);
    }

    private static Optional<String> getTableProperty(String tableName, String propertyName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        try (Statement statement = QueryExecutors.onHive().getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery("SHOW TBLPROPERTIES " + tableName);){
            while (resultSet.next()) {
                if (!propertyName.equals(resultSet.getString("prpt_name"))) continue;
                Optional<String> optional = Optional.of(resultSet.getString("prpt_value"));
                return optional;
            }
        }
        return Optional.empty();
    }
}

