/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutionException;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.testng.annotations.Test;

public class TestHiveSchema
extends ProductTest {
    @BeforeTestWithContext
    public void setUp() {
        QueryExecutors.onPresto().executeQuery("DROP TABLE IF EXISTS hive.default.test_sys_schema_disabled_table_in_default", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE hive.default.test_sys_schema_disabled_table_in_default(a bigint)", new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void tearDown() {
        QueryExecutors.onPresto().executeQuery("DROP TABLE hive.default.test_sys_schema_disabled_table_in_default", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testSysSchemaFilteredOut() {
        ((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW SCHEMAS FROM hive", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"))).satisfies(TestHiveSchema.containsFirstColumnValue("default"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("sys"));
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SHOW TABLES FROM hive.sys", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Schema 'sys' does not exist");
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM hive.sys.version", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Table 'hive.sys.version' does not exist");
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM hive.sys.table_params", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Table 'hive.sys.table_params' does not exist");
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DESCRIBE hive.sys.version", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Table 'hive.sys.version' does not exist");
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DESCRIBE hive.sys.table_params", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Table 'hive.sys.table_params' does not exist");
        ((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT schema_name FROM information_schema.schemata", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"))).satisfies(TestHiveSchema.containsFirstColumnValue("default"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("sys"));
        ((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_schema FROM information_schema.tables", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"))).satisfies(TestHiveSchema.containsFirstColumnValue("default"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("sys"));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'sys'", new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'sys' AND table_name = 'version'", new QueryExecutor.QueryParam[0])).hasNoRows();
        ((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_schema FROM information_schema.columns", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"))).satisfies(TestHiveSchema.containsFirstColumnValue("default"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("sys"));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.columns WHERE table_schema = 'sys'", new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = 'sys' AND table_name = 'version'", new QueryExecutor.QueryParam[0])).hasNoRows();
        if (this.tablePrivilegesSupported()) {
            ((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_schema FROM information_schema.table_privileges", new QueryExecutor.QueryParam[0])).doesNotHave(TestHiveSchema.containsFirstColumnValue("information_schema"))).satisfies(TestHiveSchema.containsFirstColumnValue("default"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("sys"));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.table_privileges WHERE table_schema = 'sys'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.table_privileges WHERE table_schema = 'sys' AND table_name = 'version'", new QueryExecutor.QueryParam[0])).hasNoRows();
        }
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.sys.version", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:15: Schema 'sys' does not exist");
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.sys.table_params", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:15: Schema 'sys' does not exist");
    }

    @Test(groups={"storage_formats"})
    public void testHiveInformationSchemaFilteredOut() {
        ImmutableList allInformationSchemaTables = ImmutableList.builder().add((Object)"columns").add((Object)"tables").add((Object)"views").add((Object)"schemata").add((Object)"table_privileges").add((Object)"roles").add((Object)"applicable_roles").add((Object)"enabled_roles").add((Object)"role_authorization_descriptors").build();
        List allInformationSchemaTablesAsRows = (List)allInformationSchemaTables.stream().map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).collect(ImmutableList.toImmutableList());
        List allInformationSchemaTablesExceptRoles = (List)allInformationSchemaTables.stream().filter(tableName -> !tableName.equals("roles")).filter(tableName -> !tableName.equals("role_authorization_descriptors")).collect(ImmutableList.toImmutableList());
        List allInformationSchemaTablesExceptRolesAsRows = (List)allInformationSchemaTablesExceptRoles.stream().map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).collect(ImmutableList.toImmutableList());
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW SCHEMAS FROM hive", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"));
        ((QueryAssert)((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW TABLES FROM hive.information_schema", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("tables"))).satisfies(TestHiveSchema.containsFirstColumnValue("columns"))).satisfies(TestHiveSchema.containsFirstColumnValue("table_privileges"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("column_privileges"));
        ((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM hive.information_schema.columns", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("table_catalog"))).satisfies(TestHiveSchema.containsFirstColumnValue("table_schema"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("is_updatable"));
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM hive.information_schema.column_privileges", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Table 'hive.information_schema.column_privileges' does not exist");
        ((QueryAssert)((QueryAssert)((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("DESCRIBE hive.information_schema.columns", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("table_catalog"))).satisfies(TestHiveSchema.containsFirstColumnValue("table_schema"))).satisfies(TestHiveSchema.containsFirstColumnValue("column_name"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("is_updatable"));
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DESCRIBE hive.information_schema.column_privileges", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:1: Table 'hive.information_schema.column_privileges' does not exist");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT schema_name FROM information_schema.schemata", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_schema FROM information_schema.tables", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'information_schema'", new QueryExecutor.QueryParam[0])).containsOnly(allInformationSchemaTablesAsRows);
        Assertions.assertThat(QueryExecutors.onPresto().executeQuery("SELECT table_schema, table_name FROM information_schema.tables", new QueryExecutor.QueryParam[0]).rows().stream().filter(row -> row.get(0).equals("information_schema")).map(row -> (String)row.get(1))).containsOnly((Object[])allInformationSchemaTables.toArray(new String[0]));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' AND table_name = 'column_privileges'", new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_schema FROM information_schema.columns", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("information_schema"));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' AND table_name != 'roles' AND table_name != 'role_authorization_descriptors'", new QueryExecutor.QueryParam[0])).containsOnly(allInformationSchemaTablesExceptRolesAsRows);
        Assertions.assertThat(QueryExecutors.onPresto().executeQuery("SELECT table_schema, table_name, column_name FROM information_schema.columns", new QueryExecutor.QueryParam[0]).rows().stream().filter(row -> row.get(0).equals("information_schema")).map(row -> (String)row.get(1)).filter(tableName -> !tableName.equals("roles")).filter(tableName -> !tableName.equals("role_authorization_descriptors")).distinct()).containsOnly((Object[])allInformationSchemaTablesExceptRoles.toArray(new String[0]));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = 'information_schema' AND table_name = 'columns'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"table_catalog"}), QueryAssert.Row.row((Object[])new Object[]{"table_schema"}), QueryAssert.Row.row((Object[])new Object[]{"table_name"}), QueryAssert.Row.row((Object[])new Object[]{"column_name"}), QueryAssert.Row.row((Object[])new Object[]{"ordinal_position"}), QueryAssert.Row.row((Object[])new Object[]{"column_default"}), QueryAssert.Row.row((Object[])new Object[]{"is_nullable"}), QueryAssert.Row.row((Object[])new Object[]{"data_type"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = 'information_schema' AND table_name = 'column_privileges'", new QueryExecutor.QueryParam[0])).hasNoRows();
        if (this.tablePrivilegesSupported()) {
            ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT DISTINCT table_schema FROM information_schema.table_privileges", new QueryExecutor.QueryParam[0])).satisfies(TestHiveSchema.containsFirstColumnValue("default"))).doesNotHave(TestHiveSchema.containsFirstColumnValue("information_schema"));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.table_privileges WHERE table_schema = 'information_schema'", new QueryExecutor.QueryParam[0])).hasNoRows();
            Assertions.assertThat(QueryExecutors.onPresto().executeQuery("SELECT table_schema, table_name, privilege_type FROM information_schema.table_privileges", new QueryExecutor.QueryParam[0]).rows().stream().filter(row -> row.get(0).equals("information_schema")).map(row -> (String)row.get(1))).isEmpty();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.table_privileges WHERE table_schema = 'information_schema' AND table_name = 'columns'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT table_name FROM information_schema.table_privileges WHERE table_schema = 'information_schema' AND table_name = 'column_privileges'", new QueryExecutor.QueryParam[0])).hasNoRows();
        }
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.information_schema.column_privileges", new QueryExecutor.QueryParam[0])).failsWithMessage("line 1:15: Table 'hive.information_schema.column_privileges' does not exist");
    }

    private boolean tablePrivilegesSupported() {
        try {
            QueryExecutors.onPresto().executeQuery("SELECT * FROM information_schema.table_privileges", new QueryExecutor.QueryParam[0]);
            return true;
        }
        catch (QueryExecutionException e) {
            if (Strings.nullToEmpty((String)e.getMessage()).endsWith(": This connector does not support table privileges")) {
                return false;
            }
            throw e;
        }
    }

    private static <T> Condition<QueryResult> containsFirstColumnValue(T value) {
        Objects.requireNonNull(value, "value is null");
        return new Condition(queryResult -> {
            List values = queryResult.column(1);
            if (!values.isEmpty()) {
                Class<?> expectedType = value.getClass();
                Class<?> actualType = values.get(0).getClass();
                Verify.verify((boolean)expectedType.equals(actualType), (String)"Expected QueryResult to contain %s values, but it contains %s", expectedType, actualType);
            }
            return values.contains(value);
        }, "Contains(%s)", new Object[]{value});
    }
}

