/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.JdbcDriverUtils;
import io.prestosql.tests.utils.QueryExecutors;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveStorageFormats
extends ProductTest {
    private static final String TPCH_SCHEMA = "tiny";
    @Inject(optional=true)
    @Named(value="databases.presto.admin_role_enabled")
    private boolean adminRoleEnabled;

    @DataProvider(name="storage_formats")
    public static Object[][] storageFormats() {
        return new StorageFormat[][]{{TestHiveStorageFormats.storageFormat("ORC", (Map<String, String>)ImmutableMap.of((Object)"hive.orc_optimized_writer_validate", (Object)"true"))}, {TestHiveStorageFormats.storageFormat("PARQUET")}, {TestHiveStorageFormats.storageFormat("RCBINARY", (Map<String, String>)ImmutableMap.of((Object)"hive.rcfile_optimized_writer_validate", (Object)"true"))}, {TestHiveStorageFormats.storageFormat("RCTEXT", (Map<String, String>)ImmutableMap.of((Object)"hive.rcfile_optimized_writer_validate", (Object)"true"))}, {TestHiveStorageFormats.storageFormat("SEQUENCEFILE")}, {TestHiveStorageFormats.storageFormat("TEXTFILE")}, {TestHiveStorageFormats.storageFormat("TEXTFILE", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"textfile_field_separator", (Object)"F", (Object)"textfile_field_separator_escape", (Object)"E"))}, {TestHiveStorageFormats.storageFormat("AVRO")}};
    }

    @DataProvider(name="storage_formats_with_null_format")
    public static Object[][] storageFormatsWithNullFormat() {
        return new StorageFormat[][]{{TestHiveStorageFormats.storageFormat("TEXTFILE")}, {TestHiveStorageFormats.storageFormat("RCTEXT")}, {TestHiveStorageFormats.storageFormat("SEQUENCEFILE")}};
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testInsertIntoTable(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_insert_into_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTable = String.format("CREATE TABLE %s(   orderkey      BIGINT,   partkey       BIGINT,   suppkey       BIGINT,   linenumber    INTEGER,   quantity      DOUBLE,   extendedprice DOUBLE,   discount      DOUBLE,   tax           DOUBLE,   linestatus    VARCHAR,   shipinstruct  VARCHAR,   shipmode      VARCHAR,   comment       VARCHAR,   returnflag    VARCHAR) WITH (%s)", tableName, storageFormat.getStoragePropertiesAsSql());
        QueryExecutor.query((String)createTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String insertInto = String.format("INSERT INTO %s SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice, discount, tax, linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA);
        QueryExecutor.query((String)insertInto, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(tax), sum(discount), sum(linenumber) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testCreateTableAs(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_create_table_as_select_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTableAsSelect = String.format("CREATE TABLE %s WITH (%s) AS SELECT partkey, suppkey, extendedprice FROM tpch.%s.lineitem", tableName, storageFormat.getStoragePropertiesAsSql(), TPCH_SCHEMA);
        QueryExecutor.query((String)createTableAsSelect, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(extendedprice), sum(suppkey), count(partkey) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testInsertIntoPartitionedTable(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_insert_into_partitioned_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTable = String.format("CREATE TABLE %s(   orderkey      BIGINT,   partkey       BIGINT,   suppkey       BIGINT,   linenumber    INTEGER,   quantity      DOUBLE,   extendedprice DOUBLE,   discount      DOUBLE,   tax           DOUBLE,   linestatus    VARCHAR,   shipinstruct  VARCHAR,   shipmode      VARCHAR,   comment       VARCHAR,   returnflag    VARCHAR) WITH (format='%s', partitioned_by = ARRAY['returnflag'])", tableName, storageFormat.getName());
        QueryExecutor.query((String)createTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String insertInto = String.format("INSERT INTO %s SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice, discount, tax, linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA);
        QueryExecutor.query((String)insertInto, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(tax), sum(discount), sum(length(returnflag)) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats_with_null_format", groups={"storage_formats"})
    public void testInsertAndSelectWithNullFormat(StorageFormat storageFormat) {
        String nullFormat = "null_value";
        String tableName = String.format("test_storage_format_%s_insert_and_select_with_null_format", storageFormat.getName());
        QueryExecutor.query((String)String.format("CREATE TABLE %s (value VARCHAR) WITH (format = '%s', null_format = '%s')", tableName, storageFormat.getName(), nullFormat), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String[] values = new String[]{nullFormat, null, "non-null", "", "\\N"};
        QueryAssert.Row[] storedValues = (QueryAssert.Row[])Arrays.stream(values).map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).toArray(QueryAssert.Row[]::new);
        storedValues[0] = QueryAssert.Row.row((Object[])new Object[]{null});
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(values.length, "(?)"));
        QueryExecutor.query((String)String.format("INSERT INTO %s VALUES %s", tableName, placeholders), (QueryExecutor.QueryParam[])((QueryExecutor.QueryParam[])Arrays.stream(values).map(value -> QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)value)).toArray(QueryExecutor.QueryParam[]::new)));
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(storedValues);
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats_with_null_format", groups={"storage_formats"})
    public void testSelectWithNullFormat(StorageFormat storageFormat) {
        String nullFormat = "null_value";
        String tableName = String.format("test_storage_format_%s_select_with_null_format", storageFormat.getName());
        QueryExecutor.query((String)String.format("CREATE TABLE %s (value VARCHAR) WITH (format = '%s', null_format = '%s')", tableName, storageFormat.getName(), nullFormat), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES ('non-null'), (NULL), ('%s')", tableName, nullFormat), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"non-null"}), QueryAssert.Row.row((Object[])new Object[]{null}), QueryAssert.Row.row((Object[])new Object[]{null})});
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"storage_formats"})
    public void testCreatePartitionedTableAs(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_create_table_as_select_partitioned_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String createTableAsSelect = String.format("CREATE TABLE %s WITH (%s, partitioned_by = ARRAY['returnflag']) AS SELECT tax, discount, returnflag FROM tpch.%s.lineitem", tableName, storageFormat.getStoragePropertiesAsSql(), TPCH_SCHEMA);
        QueryExecutor.query((String)createTableAsSelect, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(tax), sum(discount), sum(length(returnflag)) from %s", tableName);
        QueryExecutor.query((String)String.format("DROP TABLE %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testOrcTableCreatedInPresto() {
        QueryExecutors.onPresto().executeQuery("CREATE TABLE orc_table_created_in_presto WITH (format='ORC') AS SELECT 42 a", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM orc_table_created_in_presto", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM orc_table_created_in_presto", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM orc_table_created_in_presto WHERE a < 43", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryExecutors.onPresto().executeQuery("DROP TABLE orc_table_created_in_presto", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testSnappyCompressedParquetTableCreatedInHive() {
        String tableName = "table_created_in_hive_parquet";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (   c_bigint BIGINT,   c_varchar VARCHAR(255))STORED AS PARQUET TBLPROPERTIES(\"parquet.compression\"=\"SNAPPY\")", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES(1, 'test data')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test data"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    private static void assertResultEqualForLineitemTable(String query, String tableName) {
        QueryResult expected = QueryExecutor.query((String)String.format(query, "tpch.tiny.lineitem"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        List expectedRows = (List)expected.rows().stream().map(columns -> QueryAssert.Row.row((Object[])columns.toArray())).collect(ImmutableList.toImmutableList());
        QueryResult actual = QueryExecutor.query((String)String.format(query, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actual).hasColumns(expected.getColumnTypes()).containsExactly(expectedRows);
    }

    private void setAdminRole() {
        if (this.adminRoleEnabled) {
            return;
        }
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        try {
            JdbcDriverUtils.setRole(connection, "admin");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setSessionProperties(StorageFormat storageFormat) {
        TestHiveStorageFormats.setSessionProperties(storageFormat.getSessionProperties());
    }

    private static void setSessionProperties(Map<String, String> sessionProperties) {
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        try {
            JdbcDriverUtils.setSessionProperty(connection, "task_writer_count", "4");
            JdbcDriverUtils.setSessionProperty(connection, "redistribute_writes", "false");
            for (Map.Entry<String, String> sessionProperty : sessionProperties.entrySet()) {
                JdbcDriverUtils.setSessionProperty(connection, sessionProperty.getKey(), sessionProperty.getValue());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static StorageFormat storageFormat(String name) {
        return TestHiveStorageFormats.storageFormat(name, (Map<String, String>)ImmutableMap.of());
    }

    private static StorageFormat storageFormat(String name, Map<String, String> sessionProperties) {
        return new StorageFormat(name, sessionProperties, (Map<String, String>)ImmutableMap.of());
    }

    private static StorageFormat storageFormat(String name, Map<String, String> sessionProperties, Map<String, String> properties) {
        return new StorageFormat(name, sessionProperties, properties);
    }

    private static class StorageFormat {
        private final String name;
        private final Map<String, String> properties;
        private final Map<String, String> sessionProperties;

        private StorageFormat(String name, Map<String, String> sessionProperties, Map<String, String> properties) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.properties = Objects.requireNonNull(properties, "properties is null");
            this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        }

        public String getName() {
            return this.name;
        }

        public String getStoragePropertiesAsSql() {
            return Stream.concat(Stream.of(Maps.immutableEntry((Object)"format", (Object)this.name)), this.properties.entrySet().stream()).map(entry -> String.format("%s = '%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        }

        public Map<String, String> getSessionProperties() {
            return this.sessionProperties;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("properties", this.properties).add("sessionProperties", this.sessionProperties).toString();
        }
    }
}

