/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.BucketingType;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.hive.TransactionalTableType;
import io.prestosql.tests.hive.util.TemporaryHiveTable;
import io.prestosql.tests.utils.QueryExecutors;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveTransactionalTable
extends HiveProductTest {
    private static final Logger log = Logger.get(TestHiveTransactionalTable.class);
    private static final int TEST_TIMEOUT = 600000;

    @Test(groups={"hive_transactional"}, timeOut=600000L)
    public void testReadFullAcid() {
        this.doTestReadFullAcid(false, BucketingType.NONE);
    }

    @Test(groups={"hive_transactional"}, timeOut=600000L)
    public void testReadFullAcidBucketed() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_DEFAULT);
    }

    @Test(groups={"hive_transactional"}, timeOut=600000L)
    public void testReadFullAcidPartitioned() {
        this.doTestReadFullAcid(true, BucketingType.NONE);
    }

    @Test(groups={"hive_transactional", "storage_formats"}, timeOut=600000L)
    public void testReadFullAcidPartitionedBucketed() {
        this.doTestReadFullAcid(true, BucketingType.BUCKETED_DEFAULT);
    }

    @Test(groups={"hive_transactional"}, timeOut=600000L)
    public void testReadFullAcidBucketedV1() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_V1);
    }

    @Test(groups={"hive_transactional"}, timeOut=600000L)
    public void testReadFullAcidBucketedV2() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_V2);
    }

    private void doTestReadFullAcid(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName("read_full_acid", isPartitioned, bucketingType));){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            String selectFromOnePartitionsSql = "SELECT col, fcol FROM " + tableName + " ORDER BY col";
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (20, 3)", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MINOR, tableName, hivePartitionString, Duration.valueOf((String)"3m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol=2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            String predicate = "fcol = 1" + (isPartitioned ? " AND part_col = 2 " : "");
            QueryExecutors.onHive().executeQuery("UPDATE " + tableName + " SET col = 23 WHERE " + predicate, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, hivePartitionString, Duration.valueOf((String)"3m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
        }
    }

    @Test(groups={"hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=600000L)
    public void testReadInsertOnly(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName("insert_only", isPartitioned, bucketingType));){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("col", 4) + " STORED AS ORC " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.INSERT_ONLY, bucketingType), new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            String predicate = isPartitioned ? " WHERE part_col = 2 " : "";
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " SELECT 1", new QueryExecutor.QueryParam[0]);
            String selectFromOnePartitionsSql = "SELECT col FROM " + tableName + predicate + " ORDER BY COL";
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " SELECT 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MINOR, tableName, hivePartitionString, Duration.valueOf((String)"3m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " SELECT 3", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            if (this.getHiveVersionMajor() >= 4) {
                QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " SELECT 4", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, hivePartitionString, Duration.valueOf((String)"3m"));
                QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4})});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=600000L)
    public void testReadFullAcidWithOriginalFiles(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Presto Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_full_acid_acid_converted_table_read";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        try {
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (20, 3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol = 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("UPDATE " + tableName + " SET col = 23 WHERE fcol = 1" + (isPartitioned ? " AND part_col = 2 " : ""), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=600000L)
    public void testReadInsertOnlyWithOriginalFiles(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Presto Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_insert_only_acid_converted_table_read";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("col", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        try {
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.INSERT_ONLY, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + (isPartitioned ? " WHERE part_col = 2 " : " ORDER BY col")), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + (isPartitioned ? " WHERE part_col = 2 " : " ORDER BY col")), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hive_transactional"})
    public void testFailAcidBeforeHive3() {
        if (this.getHiveVersionMajor() >= 3) {
            throw new SkipException("This tests behavior of ACID table before Hive 3 ");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable("test_fail_acid_before_hive3_" + TemporaryHiveTable.randomTableSuffix());){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + "(a bigint) CLUSTERED BY(a) INTO 4 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Failed to open transaction. Transactional tables support requires Hive metastore version at least 3.0");
        }
    }

    @DataProvider
    public Object[][] partitioningAndBucketingTypeDataProvider() {
        return new Object[][]{{false, BucketingType.NONE}, {false, BucketingType.BUCKETED_DEFAULT}, {true, BucketingType.NONE}, {true, BucketingType.BUCKETED_DEFAULT}};
    }

    @Test(groups={"hive_transactional"}, dataProvider="testCreateAcidTableDataProvider")
    public void testCtasAcidTable(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(String.format("ctas_transactional_%s", TemporaryHiveTable.randomTableSuffix()));){
            String tableName = table.getName();
            QueryExecutor.query((String)("CREATE TABLE " + tableName + " " + TestHiveTransactionalTable.prestoTableProperties(TransactionalTableType.ACID, isPartitioned, bucketingType) + " AS SELECT * FROM (VALUES (21, 1, 1), (22, 1, 2), (23, 2, 2)) t(col, fcol, partcol)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE partcol = 2 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{22, 1}), QueryAssert.Row.row((Object[])new Object[]{23, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT col, fcol FROM " + tableName + " WHERE partcol = 2 ORDER BY col", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{22, 1}), QueryAssert.Row.row((Object[])new Object[]{23, 2})});
        }
    }

    @Test(groups={"hive_transactional"}, dataProvider="testCreateAcidTableDataProvider")
    public void testCreateAcidTable(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(String.format("create_transactional_%s", TemporaryHiveTable.randomTableSuffix()));){
            String tableName = table.getName();
            QueryExecutor.query((String)("CREATE TABLE " + tableName + " (col INTEGER, fcol INTEGER, partcol INTEGER)" + TestHiveTransactionalTable.prestoTableProperties(TransactionalTableType.ACID, isPartitioned, bucketingType)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat(() -> QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1,2,3)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessageMatching(".*Writes to Hive transactional tables are not supported.*");
        }
    }

    @DataProvider
    public Object[][] testCreateAcidTableDataProvider() {
        return new Object[][]{{false, BucketingType.NONE}, {false, BucketingType.BUCKETED_DEFAULT}, {false, BucketingType.BUCKETED_V1}, {false, BucketingType.BUCKETED_V2}, {true, BucketingType.NONE}, {true, BucketingType.BUCKETED_DEFAULT}};
    }

    private static String hiveTableProperties(TransactionalTableType transactionalTableType, BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.addAll(transactionalTableType.getHiveTableProperties());
        tableProperties.addAll(bucketingType.getHiveTableProperties());
        tableProperties.add((Object)"'NO_AUTO_COMPACTION'='true'");
        return tableProperties.build().stream().collect(Collectors.joining(",", "TBLPROPERTIES (", ")"));
    }

    private static String prestoTableProperties(TransactionalTableType transactionalTableType, boolean isPartitioned, BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.addAll(transactionalTableType.getPrestoTableProperties());
        tableProperties.addAll(bucketingType.getPrestoTableProperties("fcol", 4));
        if (isPartitioned) {
            tableProperties.add((Object)"partitioned_by = ARRAY['partcol']");
        }
        return tableProperties.build().stream().collect(Collectors.joining(",", "WITH (", ")"));
    }

    private static void compactTableAndWait(CompactionMode compactMode, String tableName, String partitionString, Duration timeout) {
        log.info("Running %s compaction on %s", new Object[]{compactMode, tableName});
        Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxDuration(java.time.Duration.ofMillis(timeout.toMillis())).withMaxAttempts(Integer.MAX_VALUE)}).onFailure(event -> {
            throw new IllegalStateException(String.format("Could not compact table %s in %d retries", tableName, event.getAttemptCount()), event.getFailure());
        }).onSuccess(event -> log.info("Finished %s compaction on %s in %s (%d tries)", new Object[]{compactMode, tableName, event.getElapsedTime(), event.getAttemptCount()})).run(() -> TestHiveTransactionalTable.tryCompactingTable(compactMode, tableName, partitionString, Duration.valueOf((String)"60s")));
    }

    private static void tryCompactingTable(CompactionMode compactMode, String tableName, String partitionString, Duration timeout) throws TimeoutException {
        List<Map<String, String>> startedCompactions;
        Instant beforeCompactionStart = Instant.now();
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s %s COMPACT '%s'", tableName, partitionString, compactMode.name()), new QueryExecutor.QueryParam[0]).getRowsCount();
        log.info("Started compactions after %s: %s", new Object[]{beforeCompactionStart, TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.empty())});
        long loopStart = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            startedCompactions = TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.of(beforeCompactionStart));
            Verify.verify((startedCompactions.size() < 2 ? 1 : 0) != 0, (String)"Expected at most 1 compaction", (Object[])new Object[0]);
            if (startedCompactions.isEmpty()) {
                log.info("Compaction has not started yet. Existing compactions: " + TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.empty()));
                continue;
            }
            String compactionState = startedCompactions.get(0).get("state");
            if (compactionState.equals("failed")) {
                log.info("Compaction has failed: %s", new Object[]{startedCompactions.get(0)});
                throw new IllegalStateException("Compaction has failed");
            }
            if (compactionState.equals("succeeded")) {
                return;
            }
            if (Duration.nanosSince((long)loopStart).compareTo(timeout) > 0) break;
        }
        log.info("Waiting for compaction has timed out: %s", new Object[]{startedCompactions.get(0)});
        throw new TimeoutException("Compaction has timed out");
    }

    private static List<Map<String, String>> getTableCompactions(CompactionMode compactionMode, String tableName, Optional<Instant> startedAfter) {
        return (List)Stream.of(QueryExecutors.onHive().executeQuery("SHOW COMPACTIONS", new QueryExecutor.QueryParam[0])).flatMap(TestHiveTransactionalTable::mapRows).filter(row -> TestHiveTransactionalTable.isCompactionForTable(compactionMode, tableName, row)).filter(row -> {
            if (startedAfter.isPresent()) {
                try {
                    return Long.parseLong((String)row.get("start time")) >= ((Instant)startedAfter.get()).truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }).collect(ImmutableList.toImmutableList());
    }

    private static Stream<Map<String, String>> mapRows(QueryResult result) {
        if (result.getRowsCount() == 0) {
            return Stream.of(new Map[0]);
        }
        List columnNames = result.row(0).stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int rowIndex = 1; rowIndex < result.getRowsCount(); ++rowIndex) {
            ImmutableMap.Builder singleRow = ImmutableMap.builder();
            List row = result.row(rowIndex);
            for (int column = 0; column < columnNames.size(); ++column) {
                String columnName = ((String)columnNames.get(column)).toLowerCase(Locale.ENGLISH);
                singleRow.put((Object)columnName, (Object)((String)row.get(column)));
            }
            rows.add((Object)singleRow.build());
        }
        return rows.build().stream();
    }

    private static String tableName(String testName, boolean isPartitioned, BucketingType bucketingType) {
        return String.format("test_%s_%b_%s_%s", testName, isPartitioned, bucketingType.name(), TemporaryHiveTable.randomTableSuffix());
    }

    private static boolean isCompactionForTable(CompactionMode compactMode, String tableName, Map<String, String> row) {
        return row.get("table").equals(tableName.toLowerCase(Locale.ENGLISH)) && row.get("type").equals(compactMode.name());
    }

    public static enum CompactionMode {
        MAJOR,
        MINOR;

    }
}

