/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.hive.TransactionalTableType;
import io.prestosql.tests.utils.QueryExecutors;
import java.util.Locale;
import java.util.stream.Collectors;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveTransactionalTableInsert
extends ProductTest {
    @Test(dataProvider="transactionalTableType", groups={"hive_transactional"})
    public void testInsertIntoTransactionalTable(TransactionalTableType type) {
        String tableName = "test_insert_into_transactional_table_" + type.name().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + "(a bigint)CLUSTERED BY(a) INTO 4 BUCKETS STORED AS ORC " + TestHiveTransactionalTableInsert.hiveTableProperties(type), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat(() -> QueryExecutor.query((String)("INSERT INTO " + tableName + " (a) VALUES (42)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Hive transactional tables are not supported: default." + tableName);
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @DataProvider
    public Object[][] transactionalTableType() {
        return new Object[][]{{TransactionalTableType.ACID}, {TransactionalTableType.INSERT_ONLY}};
    }

    private static String hiveTableProperties(TransactionalTableType transactionalTableType) {
        return transactionalTableType.getHiveTableProperties().stream().collect(Collectors.joining(",", "TBLPROPERTIES (", ")"));
    }
}

