/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.utils.QueryExecutors;
import java.math.BigDecimal;
import org.testng.annotations.Test;

public class TestHiveViews
extends HiveProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION);
    }

    @Test(groups={"hive_views"})
    public void testSelectOnView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_test_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT * FROM hive_test_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
    }

    @Test(groups={"hive_views"})
    public void testSelectOnViewFromDifferentSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view_1 AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT * FROM test_schema.hive_test_view_1", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
    }

    @Test(groups={"hive_views"})
    public void testViewWithUnsupportedCoercion() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_unsupported_coercion", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_unsupported_coercion AS SELECT length(n_comment) FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"SELECT COUNT(*) FROM view_with_unsupported_coercion", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View 'hive.default.view_with_unsupported_coercion' is stale; it must be re-created");
    }

    @Test(groups={"hive_views"})
    public void testWithUnsupportedFunction() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_repeat_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_repeat_function AS SELECT REPEAT(n_comment,2) FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"SELECT COUNT(*) FROM view_with_repeat_function", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View 'hive.default.view_with_repeat_function' is stale; it must be re-created");
    }

    @Test(groups={"hive_views"})
    public void testExistingView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_duplicate_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("View already exists");
    }

    @Test(groups={"hive_views"})
    public void testShowCreateView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_show_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_show_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SHOW CREATE VIEW hive_show_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
    }

    @Test(groups={"hive_views"})
    public void testUnsupportedLateralViews() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS pageAds", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE pageAds(pageid string, adid_list array<int>)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view as SELECT pageid, adid FROM pageAds LATERAL VIEW explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"SELECT COUNT(*) FROM hive_lateral_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Failed parsing stored view 'hive.default.hive_lateral_view': line 1:78: mismatched input 'VIEW'");
    }

    @Test(groups={"hive_views"})
    public void testIdentifierThatStartWithDigit() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_on_identifiers_starting_with_numbers", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS 7_table_with_number", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE 7_table_with_number(num string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_on_identifiers_starting_with_numbers AS SELECT * FROM 7_table_with_number", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT COUNT(*) FROM view_on_identifiers_starting_with_numbers", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
    }

    @Test(groups={"hive_views"})
    public void testHiveViewInInformationSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE;", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema;", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_schema.hive_table(a string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_schema.presto_table(a int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE VIEW test_schema.presto_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        boolean hiveWithTableNamesByType = this.getHiveVersionMajor() >= 3 || this.getHiveVersionMajor() == 2 && this.getHiveVersionMinor() >= 3;
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT * FROM information_schema.tables WHERE table_schema = 'test_schema'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "presto_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_test_view", hiveWithTableNamesByType ? "VIEW" : "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "presto_test_view", "VIEW"})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT view_definition FROM information_schema.views WHERE table_schema = 'test_schema' and table_name = 'hive_test_view'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"SELECT \"nation\".\"n_nationkey\", \"nation\".\"n_name\", \"nation\".\"n_regionkey\", \"nation\".\"n_comment\" FROM \"default\".\"nation\""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"DESCRIBE test_schema.hive_test_view", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", "bigint", "", ""})});
    }

    @Test(groups={"hive_views"})
    public void testHiveViewWithParametrizedTypes() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_view_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_parametrized(a decimal(20,4), b bigint, c varchar(20))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_view_parametrized AS SELECT * FROM hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE hive_table_parametrized VALUES (1.2345, 42, 'bar')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT * FROM hive.default.hive_view_parametrized", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("1.2345"), 42, "bar"})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT data_type FROM information_schema.columns WHERE table_name = 'hive_view_parametrized'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"bigint"}), QueryAssert.Row.row((Object[])new Object[]{"varchar(20)"})});
    }
}

