/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.utils.QueryExecutors;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestReadUniontype
extends HiveProductTest {
    private static final String TABLE_NAME = "test_read_uniontype";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void cleanup() {
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }

    @DataProvider(name="storage_formats")
    public static Object[][] storageFormats() {
        return new String[][]{{"ORC"}, {"AVRO"}};
    }

    private void createTestTable(String storageFormat) {
        this.cleanup();
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id INT,foo UNIONTYPE<INT,DOUBLE,ARRAY<STRING>>)STORED AS %s", TABLE_NAME, storageFormat), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"smoke"})
    public void testReadUniontype(String storageFormat) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        this.createTestTable(storageFormat);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 0, create_union(0, CAST(36 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 1, create_union(1, CAST(NULL AS INT), CAST(7.2 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 2, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 3, create_union(1, CAST(NULL AS INT), CAST(10.8 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 4, create_union(0, CAST(144 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 5, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('hello', 'world'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 6, create_union(0, CAST(180 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 7, create_union(1, CAST(NULL AS INT), CAST(21.6 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 8, create_union(0, CAST(252 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onPresto().executeQuery(String.format("SELECT * FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)9);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 36, null, null});
                    break;
                }
                case 1: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 7.2, null});
                    break;
                }
                case 2: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("foo", "bar")});
                    break;
                }
                case 3: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 10.8, null});
                    break;
                }
                case 4: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 144, null, null});
                    break;
                }
                case 5: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("hello", "world")});
                    break;
                }
                case 6: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 180, null, null});
                    break;
                }
                case 7: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 21.6, null});
                    break;
                }
                case 8: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 252, null, null});
                }
            }
        }
    }

    private static void assertStructEquals(Object actual, Object[] expected) {
        Assert.assertTrue((boolean)(actual instanceof LinkedHashMap));
        LinkedHashMap actualStruct = (LinkedHashMap)actual;
        Assert.assertEquals((int)actualStruct.size(), (int)expected.length);
        int i = 0;
        for (Object fieldValue : actualStruct.values()) {
            Assert.assertEquals(fieldValue, (Object)expected[i++]);
        }
    }
}

