/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive.util;

import com.google.common.collect.Iterables;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.utils.QueryExecutors;
import java.net.URI;
import java.net.URISyntaxException;

public final class TableLocationUtils {
    private TableLocationUtils() {
    }

    public static String getTableLocation(String tableName) {
        return TableLocationUtils.getTableLocation(tableName, 0);
    }

    public static String getTableLocation(String tableName, int partitionColumns) {
        StringBuilder regex = new StringBuilder("/[^/]*$");
        for (int i = 0; i < partitionColumns; ++i) {
            regex.insert(0, "/[^/]*");
        }
        return (String)Iterables.getOnlyElement((Iterable)QueryExecutors.onPresto().executeQuery(String.format("SELECT DISTINCT regexp_replace(\"$path\", '%s', '') FROM %s", regex.toString(), tableName), new QueryExecutor.QueryParam[0]).column(1));
    }

    public static String getTablePath(String tableName, int partitionColumns) throws URISyntaxException {
        String location = TableLocationUtils.getTableLocation(tableName, partitionColumns);
        URI uri = new URI(location);
        return uri.getPath();
    }
}

