/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.iceberg;

import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestIcebergBasic
extends ProductTest {
    private static final String SPARK_CATALOG = "iceberg_test";
    private static final String PRESTO_CATALOG = "iceberg";
    private static final String TABLE_NAME = "test_iceberg_basic";
    private static final String SPARK_TABLE_NAME = String.format("%s.default.%s", "iceberg_test", "test_iceberg_basic");
    private static final String PRESTO_TABLE_NAME = String.format("%s.default.%s", "iceberg", "test_iceberg_basic");

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTables() {
        QueryExecutors.onPresto().executeQuery(String.format("DROP TABLE IF EXISTS %s", PRESTO_TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testCompatibility() {
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE %s (id BIGINT) USING ICEBERG", SPARK_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s VALUES (42)", SPARK_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult sparkQueryResult = QueryExecutors.onSpark().executeQuery(String.format("SELECT * FROM %s", SPARK_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)sparkQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42L})});
        QueryResult prestoQueryResult = QueryExecutors.onPresto().executeQuery(String.format("SELECT * FROM %s", PRESTO_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)prestoQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42L})});
    }
}

