/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.iceberg;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestIcebergCreateTable
extends ProductTest {
    @Test(groups={"iceberg", "storage_formats"})
    public void testCreateTable() {
        QueryExecutor queryExecutor = QueryExecutors.onPresto();
        queryExecutor.executeQuery("CREATE SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("use iceberg.iceberg", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("CREATE TABLE test_create_table(a bigint, b varchar)", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("INSERT INTO test_create_table(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryExecutor.executeQuery("SELECT * FROM test_create_table", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        queryExecutor.executeQuery("DROP TABLE test_create_table", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("DROP SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats"})
    public void testCreateTableAsSelect() {
        QueryExecutor queryExecutor = QueryExecutors.onPresto();
        queryExecutor.executeQuery("CREATE SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("use iceberg.iceberg", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("CREATE TABLE test_create_table_as_select AS SELECT * FROM (VALUES   (NULL, NULL),   (-42, 'abc'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')) t(a, b)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryExecutor.executeQuery("SELECT * FROM test_create_table_as_select", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        queryExecutor.executeQuery("DROP TABLE test_create_table_as_select", new QueryExecutor.QueryParam[0]);
        queryExecutor.executeQuery("DROP SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }
}

