/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import io.prestosql.tempto.query.QueryResult;
import java.util.function.Supplier;
import org.testng.Assert;

public final class QueryAssertions {
    public static void assertContainsEventually(Supplier<QueryResult> all, QueryResult expectedSubset, Duration timeout) {
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertContains((QueryResult)all.get(), expectedSubset));
    }

    public static void assertContains(QueryResult all, QueryResult expectedSubset) {
        for (Object row : expectedSubset.rows()) {
            if (all.rows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getRowsCount(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all.rows(), (int)100)), expectedSubset.getRowsCount(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset.rows(), (int)100))));
        }
    }

    private QueryAssertions() {
    }
}

