/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.utils.QueryExecutors;
import java.net.URI;
import java.net.URISyntaxException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestImpersonation
extends ProductTest {
    private QueryExecutor aliceExecutor;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.alice@presto.jdbc_user")
    private String aliceJdbcUser;
    @Inject
    @Named(value="databases.presto.configured_hdfs_user")
    private String configuredHdfsUser;

    @BeforeTestWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToPresto("alice@presto");
    }

    @Test(groups={"hdfs_no_impersonation", "profile_specific_tests"})
    public void testHdfsImpersonationDisabled() {
        String tableName = "check_hdfs_impersonation_disabled";
        this.checkTableOwner(tableName, this.configuredHdfsUser, this.aliceExecutor);
    }

    @Test(groups={"hdfs_impersonation", "profile_specific_tests"})
    public void testHdfsImpersonationEnabled() {
        String tableName = "check_hdfs_impersonation_enabled";
        this.checkTableOwner(tableName, this.aliceJdbcUser, this.aliceExecutor);
        this.checkTableGroup(tableName, this.aliceExecutor);
    }

    private static String getTableLocation(QueryExecutor executor, String tableName) {
        String location = (String)Iterables.getOnlyElement((Iterable)executor.executeQuery(String.format("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM %s", tableName), new QueryExecutor.QueryParam[0]).column(1));
        if (location.startsWith("hdfs://")) {
            try {
                URI uri = new URI(location);
                return uri.getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return location;
    }

    private void checkTableOwner(String tableName, String expectedOwner, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = TestImpersonation.getTableLocation(executor, tableName);
        String owner = this.hdfsClient.getOwner(tableLocation);
        Assert.assertEquals((String)owner, (String)expectedOwner);
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    private void checkTableGroup(String tableName, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = TestImpersonation.getTableLocation(executor, tableName);
        String warehouseLocation = tableLocation.substring(0, tableLocation.lastIndexOf("/"));
        String warehouseLocationGroup = this.hdfsClient.getGroup(warehouseLocation);
        String tableLocationGroup = this.hdfsClient.getGroup(warehouseLocation);
        Assert.assertEquals((String)tableLocationGroup, (String)warehouseLocationGroup);
    }
}

