/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests;

import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.context.ThreadLocalTestContextHolder;
import io.prestosql.tempto.fulfillment.table.ImmutableTableRequirement;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSimpleQuery
extends ProductTest {
    @BeforeTestWithContext
    public void beforeTest() {
        Assertions.assertThat((boolean)ThreadLocalTestContextHolder.testContextIfSet().isPresent()).isTrue();
    }

    @AfterTestWithContext
    public void afterTest() {
        Assertions.assertThat((boolean)ThreadLocalTestContextHolder.testContextIfSet().isPresent()).isTrue();
    }

    @Test(groups={"simple", "smoke"})
    @Requires(value={SimpleTestRequirements.class})
    public void selectAllFromNation() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select * from nation", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
    }

    @Test(groups={"simple", "smoke"})
    @Requires(value={SimpleTestRequirements.class})
    public void selectCountFromNation() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select count(*) from nation", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
    }

    private static class SimpleTestRequirements
    implements RequirementsProvider {
        private SimpleTestRequirements() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return new ImmutableTableRequirement((TableDefinition)TpchTableDefinitions.NATION);
        }
    }
}

