/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.cassandra;

import com.datastax.driver.core.utils.Bytes;
import io.airlift.units.Duration;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.internal.query.CassandraQueryExecutor;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.TpchTableResults;
import io.prestosql.tests.cassandra.CassandraTpchTableDefinitions;
import io.prestosql.tests.cassandra.DataTypesTableDefinition;
import io.prestosql.tests.utils.QueryAssertions;
import io.prestosql.tests.utils.QueryExecutors;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestSelect
extends ProductTest
implements RequirementsProvider {
    private Configuration configuration;

    public Requirement getRequirements(Configuration configuration) {
        this.configuration = configuration;
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_NATION), TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER), TableRequirements.immutableTable((TableDefinition)DataTypesTableDefinition.CASSANDRA_ALL_TYPES)});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectNation() {
        String sql = String.format("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM %s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithEqualityFilterOnPartitioningKey() {
        String sql = String.format("SELECT n_nationkey FROM %s.%s.%s WHERE n_nationkey = 0", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithFilterOnPartitioningKey() {
        String sql = String.format("SELECT n_nationkey FROM %s.%s.%s WHERE n_nationkey > 23", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{24})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithEqualityFilterOnNonPartitioningKey() {
        String sql = String.format("SELECT n_name FROM %s.%s.%s WHERE n_name = 'UNITED STATES'", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"UNITED STATES"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithNonEqualityFilterOnNonPartitioningKey() {
        String sql = String.format("SELECT n_name FROM %s.%s.%s WHERE n_name < 'B'", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ALGERIA"}), QueryAssert.Row.row((Object[])new Object[]{"ARGENTINA"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithMorePartitioningKeysThanLimit() {
        String sql = String.format("SELECT s_suppkey FROM %s.%s.%s WHERE s_suppkey = 10", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithMorePartitioningKeysThanLimitNonPK() {
        String sql = String.format("SELECT s_suppkey FROM %s.%s.%s WHERE s_name = 'Supplier#000000010'", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testAllDataTypes() {
        QueryResult query = QueryExecutor.query((String)String.format("SELECT a, b, bl, bo, d, do, dt, f, fr, i, integer, l, m, s, si, t, ti, ts, tu, u, v, vari FROM %s.%s.%s", "cassandra", "test", DataTypesTableDefinition.CASSANDRA_ALL_TYPES.getName()), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)query).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.VARBINARY, JDBCType.BOOLEAN, JDBCType.DOUBLE, JDBCType.DOUBLE, JDBCType.DATE, JDBCType.REAL, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.INTEGER, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.SMALLINT, JDBCType.VARCHAR, JDBCType.TINYINT, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR}).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u0000", Long.MIN_VALUE, Bytes.fromHexString((String)"0x00").array(), false, Float.valueOf(0.0f), Double.MIN_VALUE, Date.valueOf("1970-01-02"), Float.valueOf(Float.MIN_VALUE), "[0]", "0.0.0.0", Integer.MIN_VALUE, "[0]", "{\"\\u0000\":-2147483648,\"a\":0}", "[0]", (short)Short.MIN_VALUE, "\u0000", (byte)-128, Timestamp.from(OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()), "d2177dd0-eaa2-11de-a572-001b779c76e3", "01234567-0123-0123-0123-0123456789ab", "\u0000", String.valueOf(Long.MIN_VALUE)}), QueryAssert.Row.row((Object[])new Object[]{"the quick brown fox jumped over the lazy dog", Long.MAX_VALUE, "01234".getBytes(StandardCharsets.UTF_8), true, Double.valueOf("99999999999999999999999999999999999999"), Double.MAX_VALUE, Date.valueOf("9999-12-31"), Float.valueOf(Float.MAX_VALUE), "[4,5,6,7]", "255.255.255.255", Integer.MAX_VALUE, "[4,5,6]", "{\"a\":1,\"b\":2}", "[4,5,6]", (short)Short.MAX_VALUE, "this is a text value", (byte)127, Timestamp.from(OffsetDateTime.of(9999, 12, 31, 23, 59, 59, 0, ZoneOffset.UTC).toInstant()), "d2177dd0-eaa2-11de-a572-001b779c76e3", "01234567-0123-0123-0123-0123456789ab", "abc", String.valueOf(Long.MAX_VALUE)}), QueryAssert.Row.row((Object[])new Object[]{"def", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testNationJoinNation() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        String sql = String.format("SELECT n1.n_name, n2.n_regionkey FROM %s n1 JOIN %s n2 ON n1.n_nationkey = n2.n_regionkey WHERE n1.n_nationkey=3", tableName, tableName);
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testNationJoinRegion() {
        String sql = String.format("SELECT c.n_name, t.name FROM %s.%s.%s c JOIN tpch.tiny.region t ON c.n_regionkey = t.regionkey WHERE c.n_nationkey=3", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", "AMERICA"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectAllTypePartitioningMaterializedView() {
        String materializedViewName = String.format("%s_partitioned_mv", DataTypesTableDefinition.CASSANDRA_ALL_TYPES.getName());
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", materializedViewName));
        this.onCassandra(String.format("CREATE MATERIALIZED VIEW %s.%s AS SELECT * FROM %s.%s WHERE b IS NOT NULL PRIMARY KEY (a, b)", "test", materializedViewName, "test", DataTypesTableDefinition.CASSANDRA_ALL_TYPES.getName()));
        QueryAssertions.assertContainsEventually(() -> QueryExecutor.query((String)String.format("SHOW TABLES FROM %s.%s", "cassandra", "test"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), QueryExecutor.query((String)String.format("SELECT '%s'", materializedViewName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryAssertions.assertContainsEventually(() -> QueryExecutor.query((String)String.format("SELECT status_replicated FROM %s.system.built_views WHERE view_name = '%s'", "cassandra", materializedViewName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), QueryExecutor.query((String)"SELECT true", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryResult query = QueryExecutor.query((String)String.format("SELECT a, b, bl, bo, d, do, dt, f, fr, i, integer, l, m, s, si, t, ti, ts, tu, u, v, vari FROM %s.%s.%s WHERE a = '\u0000'", "cassandra", "test", materializedViewName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)query).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.VARBINARY, JDBCType.BOOLEAN, JDBCType.DOUBLE, JDBCType.DOUBLE, JDBCType.DATE, JDBCType.REAL, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.INTEGER, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.SMALLINT, JDBCType.VARCHAR, JDBCType.TINYINT, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR}).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u0000", Long.MIN_VALUE, Bytes.fromHexString((String)"0x00").array(), false, Float.valueOf(0.0f), Double.MIN_VALUE, Date.valueOf("1970-01-02"), Float.valueOf(Float.MIN_VALUE), "[0]", "0.0.0.0", Integer.MIN_VALUE, "[0]", "{\"\\u0000\":-2147483648,\"a\":0}", "[0]", (short)Short.MIN_VALUE, "\u0000", (byte)-128, Timestamp.from(OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()), "d2177dd0-eaa2-11de-a572-001b779c76e3", "01234567-0123-0123-0123-0123456789ab", "\u0000", String.valueOf(Long.MIN_VALUE)})});
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", materializedViewName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectClusteringMaterializedView() {
        String mvName = "clustering_mv";
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", mvName));
        this.onCassandra(String.format("CREATE MATERIALIZED VIEW %s.%s AS SELECT * FROM %s.%s WHERE s_nationkey IS NOT NULL PRIMARY KEY (s_nationkey, s_suppkey) WITH CLUSTERING ORDER BY (s_nationkey DESC)", "test", mvName, "test", CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER.getName()));
        QueryAssertions.assertContainsEventually(() -> QueryExecutor.query((String)String.format("SHOW TABLES FROM %s.%s", "cassandra", "test"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), QueryExecutor.query((String)String.format("SELECT '%s'", mvName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryAssertions.assertContainsEventually(() -> QueryExecutor.query((String)String.format("SELECT status_replicated FROM %s.system.built_views WHERE view_name = '%s'", "cassandra", mvName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), QueryExecutor.query((String)"SELECT true", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryResult aggregateQueryResult = QueryExecutors.onPresto().executeQuery(String.format("SELECT MAX(s_nationkey), SUM(s_suppkey), AVG(s_acctbal) FROM %s.%s.%s WHERE s_suppkey BETWEEN 1 AND 10 ", "cassandra", "test", mvName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)aggregateQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{24, 55, 4334.653})});
        QueryResult orderedResult = QueryExecutors.onPresto().executeQuery(String.format("SELECT s_nationkey, s_suppkey, s_acctbal FROM %s.%s.%s WHERE s_nationkey = 1 LIMIT 1", "cassandra", "test", mvName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)orderedResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 3, 4192.4})});
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", mvName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testProtocolVersion() {
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery(String.format("SELECT native_protocol_version FROM %s.system.local", "cassandra"), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"4"})});
    }

    private void onCassandra(String query) {
        try (CassandraQueryExecutor queryExecutor = new CassandraQueryExecutor(this.configuration);){
            queryExecutor.executeQuery(query);
        }
    }
}

