/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.log.Logger;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tests.cli.PrestoCliProcess;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class PrestoCliLauncher
extends ProductTest {
    private static final Logger log = Logger.get(PrestoCliLauncher.class);
    protected static final long TIMEOUT = 300000L;
    protected final List<String> nationTableInteractiveLines = Resources.readLines((URL)Resources.getResource((String)"io/prestosql/tests/cli/interactive_query.results"), (Charset)StandardCharsets.UTF_8);
    protected final List<String> nationTableBatchLines = Resources.readLines((URL)Resources.getResource((String)"io/prestosql/tests/cli/batch_query.results"), (Charset)StandardCharsets.UTF_8);
    @Inject
    @Named(value="databases.presto.host")
    protected String serverHost;
    @Inject
    @Named(value="databases.presto.server_address")
    protected String serverAddress;
    protected PrestoCliProcess presto;

    protected PrestoCliLauncher() throws IOException {
    }

    protected void stopPresto() throws InterruptedException {
        if (this.presto != null) {
            this.presto.close();
            this.presto = null;
        }
    }

    protected void launchPrestoCli(String ... arguments) throws IOException {
        this.launchPrestoCli(Arrays.asList(arguments));
    }

    protected void launchPrestoCli(List<String> arguments) throws IOException {
        this.presto = new PrestoCliProcess(this.getProcessBuilder(arguments).start());
    }

    protected ProcessBuilder getProcessBuilder(List<String> arguments) {
        ImmutableList command = ImmutableList.builder().add((Object)"/docker/presto-cli").addAll(arguments).build();
        log.info("Running command %s", new Object[]{command});
        return new ProcessBuilder((List<String>)command);
    }
}

