/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestHiveMaterializedView
extends HiveProductTest {
    private boolean isTestEnabled() {
        return this.getHiveVersionMajor() >= 3;
    }

    @BeforeTestWithContext
    public void setUp() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_materialized_view_table(x string) STORED AS ORC TBLPROPERTIES('transactional'='true')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO test_materialized_view_table VALUES ('a'), ('a'), ('b')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE MATERIALIZED VIEW test_materialized_view_view PARTITIONED ON (x) STORED AS ORC AS SELECT x, count(*) c FROM test_materialized_view_table GROUP BY x", new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void tearDown() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryExecutors.onHive().executeQuery("DROP MATERIALIZED VIEW IF EXISTS test_materialized_view_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_materialized_view_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testMetadata() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW TABLES", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"test_materialized_view_table"}), QueryAssert.Row.row((Object[])new Object[]{"test_materialized_view_view"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW COLUMNS FROM test_materialized_view_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c", "bigint", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"x", "varchar", "partition key", ""})});
    }

    @Test(groups={"storage_formats"})
    public void testRead() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT x, c FROM test_materialized_view_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", 2}), QueryAssert.Row.row((Object[])new Object[]{"b", 1})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT x, c FROM test_materialized_view_view WHERE x = 'a'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", 2})});
    }

    @Test(groups={"storage_formats"})
    public void testWrite() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("INSERT INTO test_materialized_view_view(x, c) VALUES ('x', 42)", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot write to Hive materialized view");
    }
}

