/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.hive.TransactionalTableType;
import io.prestosql.tests.utils.QueryExecutors;
import java.util.Locale;
import java.util.stream.Collectors;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveTransactionalTableInsert
extends HiveProductTest {
    @Test(dataProvider="transactionalTableType", groups={"hive_transactional"})
    public void testInsertIntoTransactionalTable(TransactionalTableType type) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_insert_into_transactional_table_" + type.name().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + "(a bigint)CLUSTERED BY(a) INTO 4 BUCKETS STORED AS ORC " + TestHiveTransactionalTableInsert.hiveTableProperties(type), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutor.query((String)("INSERT INTO " + tableName + " (a) VALUES (42)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @DataProvider
    public Object[][] transactionalTableType() {
        return new Object[][]{{TransactionalTableType.ACID}, {TransactionalTableType.INSERT_ONLY}};
    }

    private static String hiveTableProperties(TransactionalTableType transactionalTableType) {
        return transactionalTableType.getHiveTableProperties().stream().collect(Collectors.joining(",", "TBLPROPERTIES (", ")"));
    }
}

