/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.io.Resources;
import com.google.inject.name.Named;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.testng.annotations.Test;

public class TestParquetSymlinkInputFormat {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @Test(groups={"storage_formats"})
    public void testSymlinkTable() throws Exception {
        String table = "test_parquet_symlink";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + table + "(value int) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_parquet_symlink";
        this.saveResourceOnHdfs("data.parquet", dataDir + "/data.parquet");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/data.parquet", dataDir));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + table, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
    }

    @Test(groups={"avro", "storage_formats"})
    public void testSymlinkTableWithMultipleParentDirectories() throws Exception {
        String table = "test_parquet_symlink_with_multiple_parents";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + table + "(value int) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_parquet_symlink_with_multiple_parents";
        String anotherDataDir = this.warehouseDirectory + "/data2_test_parquet_symlink_with_multiple_parents";
        this.saveResourceOnHdfs("data.parquet", dataDir + "/data.parquet");
        this.saveResourceOnHdfs("data.parquet", anotherDataDir + "/data.parquet");
        this.hdfsClient.saveFile(dataDir + "/dontread.txt", "This file will cause an error if read as avro.");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/data.parquet\nhdfs:%s/data.parquet", dataDir, anotherDataDir));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT COUNT(*) as cnt FROM " + table, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
        this.hdfsClient.delete(anotherDataDir);
    }

    private void saveResourceOnHdfs(String resource, String location) throws IOException {
        this.hdfsClient.delete(location);
        try (InputStream inputStream = Resources.getResource((String)Paths.get("io/prestosql/tests/hive/data/single_int_column/", resource).toString()).openStream();){
            this.hdfsClient.saveFile(location, inputStream);
        }
    }
}

