/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive.util;

import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.utils.QueryExecutors;
import java.security.SecureRandom;
import java.util.Objects;

public class TemporaryHiveTable
implements AutoCloseable {
    private static final SecureRandom random = new SecureRandom();
    private static final int RANDOM_SUFFIX_LENGTH = 12;
    private final String name;

    public static TemporaryHiveTable temporaryHiveTable(String tableName) {
        return new TemporaryHiveTable(tableName);
    }

    public static String randomTableSuffix() {
        String randomSuffix = Long.toString(Math.abs(random.nextLong()), 36);
        return randomSuffix.substring(0, Math.min(12, randomSuffix.length()));
    }

    private TemporaryHiveTable(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    public void closeQuietly(Exception e) {
        block3: {
            try {
                TemporaryHiveTable justCloseIt = this;
                if (justCloseIt != null) {
                    justCloseIt.close();
                }
            }
            catch (Exception closeException) {
                if (e == closeException) break block3;
                e.addSuppressed(closeException);
            }
        }
    }

    @Override
    public void close() {
        QueryExecutors.onHive().executeQuery("DROP TABLE " + this.name, new QueryExecutor.QueryParam[0]);
    }
}

